/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIPotions;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityAtomicBoom
extends Entity
implements IEntityAdditionalSpawnData,
ILightProvider {
    public float size;
    public int progress = 0;

    public EntityAtomicBoom(World worldIn) {
        super(worldIn);
    }

    public EntityAtomicBoom(World worldIn, float size) {
        this(worldIn);
        this.size = size;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.progress;
        if (this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 4L == 0L) {
            if (this.progress < 40) {
                ParticleUtils.spawnShockwave(this.field_70165_t, this.field_70163_u + 1.5 * (double)this.size, this.field_70161_v, 20.0f, 2.5f);
            }
            if (this.progress > 10 && this.progress < 360 && this.progress < 30) {
                ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 0.5 * (double)this.size, this.field_70161_v, 10.0f, 0.0f, 0.5f);
            }
            if (this.progress > 20 && this.progress < 340) {
                if (this.progress < 320) {
                    ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 4.0 + 3.5 * (double)this.size, this.field_70161_v, 20.0f, 0.05f, -0.25f);
                }
                ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 4.0 + 1.5 * (double)this.size, this.field_70161_v, 10.0f, 0.0f, 0.5f);
            }
            if (this.progress > 20 && this.progress < 320) {
                ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 4.0 + 1.5 * (double)this.size, this.field_70161_v, 20.0f, -0.01f, 0.25f);
                if (this.progress < 35) {
                    ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 4.0 + 3.5 * (double)this.size, this.field_70161_v, 10.0f, 0.0f, 0.5f);
                }
            }
            if (this.progress > 25 && this.progress < 300) {
                ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 4.0 + 6.5 * (double)this.size, this.field_70161_v, 20.0f, -0.01f, 0.25f);
                if (this.progress < 40) {
                    ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 4.0 + 6.5 * (double)this.size, this.field_70161_v, 10.0f, 0.0f, 0.5f);
                }
            }
            if (this.progress > 30 && this.progress < 280) {
                ParticleUtils.spawnAtomicBoomCore(this, this.field_70165_t, this.field_70163_u + 4.0 + 12.5 * (double)this.size, this.field_70161_v, 15.0f, -0.01f, 0.125f);
            }
            if (this.progress > 40 && this.progress < 280) {
                ParticleUtils.spawnAtomicBoomRing(this, this.field_70165_t, this.field_70163_u + 4.0 + 18.5 * (double)this.size, this.field_70161_v, 25.0f, 0.25f, -0.05f);
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.progress > 20 && this.progress < 60) {
            int border = (int)(8.0f * this.size * 16.0f / 40.0f);
            int prog = (this.progress - 20) * border;
            int heightDiff = (int)(70.0f * this.size);
            BlockPos position = this.func_180425_c();
            for (int hh = position.func_177956_o() - heightDiff; hh <= position.func_177956_o() + heightDiff; ++hh) {
                for (int x = position.func_177958_n() - prog; x <= position.func_177958_n() + prog; ++x) {
                    int z;
                    for (z = position.func_177952_p() - prog; z <= position.func_177952_p() - prog + border; ++z) {
                        this.destroyFoliage(x, hh, z, EnumFacing.SOUTH);
                    }
                    for (z = position.func_177952_p() + prog - border; z <= position.func_177952_p() + prog; ++z) {
                        this.destroyFoliage(x, hh, z, EnumFacing.NORTH);
                    }
                }
                for (int z = position.func_177952_p() - prog; z <= position.func_177952_p() + prog; ++z) {
                    int x;
                    for (x = position.func_177958_n() - prog; x <= position.func_177958_n() - prog + border; ++x) {
                        this.destroyFoliage(x, hh, z, EnumFacing.EAST);
                    }
                    for (x = position.func_177958_n() + prog - border; x <= position.func_177958_n() + prog; ++x) {
                        this.destroyFoliage(x, hh, z, EnumFacing.WEST);
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.progress > 400) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.func_82737_E() % 10L == 0L) {
            EntityLivingBase[] entities;
            AxisAlignedBB aabb = new AxisAlignedBB(this.func_180425_c()).func_186662_g((double)(40.0f * this.size));
            for (EntityLivingBase e : entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, aabb).toArray(new EntityLivingBase[0])) {
                e.func_70690_d(new PotionEffect(IIPotions.nuclear_heat, 400, 0, false, false));
            }
            for (EntityLivingBase e : entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, aabb.func_186662_g((double)(20.0f * this.size))).toArray(new EntityLivingBase[0])) {
                if (e instanceof EntityPlayer && ((EntityPlayer)e).func_184812_l_()) continue;
                e.func_70690_d(new PotionEffect(IIPotions.radiation, 2000, 0, false, false));
            }
        }
    }

    private void destroyFoliage(int x, int y, int z, EnumFacing facing) {
        BlockPos pp = new BlockPos(x, y, z);
        if (!this.field_70170_p.func_189509_E(pp)) {
            boolean b;
            IBlockState state = this.field_70170_p.func_180495_p(pp);
            Material material = state.func_185904_a();
            boolean bl = b = material == Material.field_151575_d || material == Material.field_151580_n || material == Material.field_151593_r || material == Material.field_151570_A || material == Material.field_151589_v || material == Material.field_151592_s || material == Material.field_151585_k || material == Material.field_151597_y || material == Material.field_151596_z || material == Material.field_151584_j || material == Material.field_151569_G || material == Material.field_151568_F || material == Material.field_151582_l || material == Material.field_151594_q || material == Material.field_151598_x || material == Material.field_151588_w;
            if (this.progress < 38) {
                if (b) {
                    this.field_70170_p.func_175698_g(pp);
                }
            } else {
                if (this.progress < 52 && material == Material.field_151575_d && state.func_177227_a().contains(BlockLog.field_176299_a)) {
                    this.field_70170_p.func_175656_a(pp, IIContent.blockCharredLog.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, state.func_177229_b((IProperty)BlockLog.field_176299_a)));
                } else if (b) {
                    this.field_70170_p.func_175698_g(pp);
                }
                if (material == Material.field_151585_k || material == Material.field_151597_y || material == Material.field_151596_z || material == Material.field_151584_j || material == Material.field_151569_G || material == Material.field_151568_F || material == Material.field_151582_l || material == Material.field_151594_q || material == Material.field_151598_x || material == Material.field_151588_w) {
                    this.field_70170_p.func_175698_g(pp);
                }
            }
        }
    }

    public float func_70013_c() {
        return 15.0f;
    }

    public int func_70070_b() {
        return super.func_70070_b();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.size = compound.func_74760_g("size");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("size", this.size);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Light provideLight() {
        return Light.builder().pos((Entity)this).radius(32.0f * this.size).color(1.0f, 1.0f, 1.0f).build();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.size);
        buffer.writeInt(this.progress);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.size = buffer.readFloat();
        this.progress = buffer.readInt();
    }
}

