/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.hand_weapon;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansAnimations;
import pl.pabilo8.immersiveintelligence.common.entity.hans.tasks.AIHansBase;
import pl.pabilo8.immersiveintelligence.common.items.weapons.ItemIIRailgunOverride;

public class AIHansRailgun
extends AIHansBase {
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int holdFireTime;
    boolean sniper = false;
    private final float maxAttackDistance;
    private final float minAttackDistance;
    private final float safeAttackDistance;

    public AIHansRailgun(EntityHans hans, double movespeed, int holdFireTime, float minAttackDistanceIn, float maxAttackDistanceIn) {
        super(hans);
        this.entityMoveSpeed = movespeed;
        this.minAttackDistance = minAttackDistanceIn * minAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.safeAttackDistance = (float)MathHelper.func_151238_b((double)this.minAttackDistance, (double)this.maxAttackDistance, (double)0.35);
        this.holdFireTime = holdFireTime;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.hans.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return this.hans.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemIIRailgunOverride && this.hasAnyAmmo();
    }

    private boolean hasAnyAmmo() {
        this.hans.hasAmmo = !ItemIIRailgunOverride.findAmmo((EntityLivingBase)this.hans).func_190926_b();
        return this.hans.hasAmmo;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.hans.func_70661_as().func_75500_f() || this.attackTarget != null && !(this.hans.func_174791_d().func_72438_d(this.attackTarget.func_174791_d()) < 1.25);
    }

    public void func_75251_c() {
        if (this.attackTarget != null) {
            this.hans.func_70095_a(false);
        }
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        boolean flag;
        if (this.attackTarget == null || this.attackTarget.field_70128_L || !this.hasAnyAmmo()) {
            this.hans.func_70095_a(false);
            this.func_75251_c();
            return;
        }
        double d0 = this.hans.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean bl = flag = this.hans.func_70635_at().func_75522_a((Entity)this.attackTarget) && this.canShootEntity(this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if ((d0 <= 60.0 || !this.hans.func_70661_as().func_75500_f() && d0 <= 200.0) && this.seeTime >= 20) {
            Vec3d away;
            if (this.hans.func_70661_as().func_75500_f() && (away = RandomPositionGenerator.func_75461_b((EntityCreature)this.hans, (int)40, (int)10, (Vec3d)this.attackTarget.func_174791_d())) != null) {
                this.hans.func_70661_as().func_75492_a(away.field_72450_a, away.field_72448_b, away.field_72449_c, this.entityMoveSpeed * 1.125);
                this.hans.func_70031_b(true);
            }
            return;
        }
        if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 5) {
            this.hans.func_70031_b(false);
            this.hans.func_70661_as().func_75499_g();
        } else {
            this.hans.func_70031_b(false);
            this.hans.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        Vec3d add = this.attackTarget.func_174791_d().func_178787_e(this.attackTarget.func_70040_Z());
        this.hans.func_70671_ap().func_75650_a(add.field_72450_a, add.field_72448_b, add.field_72449_c, 30.0f, 30.0f);
        if (!flag) {
            return;
        }
        ItemStack backpack = this.hans.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack railgun = this.hans.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (EnergyHelper.isFluxItem((ItemStack)backpack) && EnergyHelper.isFluxItem((ItemStack)railgun)) {
            EnergyHelper.insertFlux((ItemStack)railgun, (int)99999, (boolean)false);
        }
        if (this.rangedAttackTime < 0) {
            this.hans.func_184602_cy();
            ++this.rangedAttackTime;
        }
        if (this.rangedAttackTime < this.holdFireTime) {
            this.hans.func_184598_c(EnumHand.MAIN_HAND);
            if (railgun.func_77973_b() instanceof ItemIIRailgunOverride) {
                ItemStack ammo = ItemIIRailgunOverride.findAmmo((EntityLivingBase)this.hans);
                if (ItemIIRailgunOverride.isAmmo(ammo)) {
                    this.hans.hasAmmo = true;
                    this.hans.func_70625_a((Entity)this.attackTarget, 30.0f, 0.0f);
                    IEContent.itemRailgun.onUsingTick(railgun, (EntityLivingBase)this.hans, this.rangedAttackTime++);
                }
                this.hans.field_70125_A = this.calculateBallisticAngle(ammo, this.attackTarget);
                IEContent.itemRailgun.func_77663_a(railgun, this.hans.field_70170_p, (Entity)this.hans, 0, true);
                this.sniper = ((ItemIIRailgunOverride)railgun.func_77973_b()).getUpgrades(railgun).func_74767_n("scope");
                if (this.rangedAttackTime >= this.holdFireTime) {
                    IEContent.itemRailgun.func_77615_a(railgun, this.hans.field_70170_p, (EntityLivingBase)this.hans, IEContent.itemRailgun.func_77626_a(railgun) - this.rangedAttackTime);
                    this.rangedAttackTime = -10;
                }
            }
        }
    }

    private float calculateBallisticAngle(ItemStack ammo, EntityLivingBase attackTarget) {
        if (ammo.func_77973_b() == IIContent.itemRailgunGrenade) {
            return Utils.getDirectFireAngle(IIContent.itemRailgunGrenade.getDefaultVelocity(), IIContent.itemRailgunGrenade.getMass(ammo), this.hans.func_174791_d().func_72441_c(0.0, (double)this.hans.func_70047_e() - (double)0.1f, 0.0).func_178788_d(Utils.getEntityCenter((Entity)attackTarget)));
        }
        return Utils.getIEDirectRailgunAngle(ammo, this.hans.func_174791_d().func_72441_c(0.0, (double)this.hans.func_70047_e(), 0.0).func_178788_d(Utils.getEntityCenter((Entity)attackTarget)));
    }

    @Override
    public void setRequiredAnimation() {
        if (this.hans.func_70661_as().func_75500_f()) {
            if (this.attackTarget != null && !this.attackTarget.field_70128_L && this.seeTime > 10) {
                this.hans.legAnimation = this.sniper && !this.hans.enemyContact ? HansAnimations.HansLegAnimation.LYING : HansAnimations.HansLegAnimation.KNEELING;
            }
        } else {
            this.hans.legAnimation = HansAnimations.HansLegAnimation.STANDING;
        }
    }
}

