/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataStorageItem;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIFunctionalCircuit
extends ItemIIBase
implements IDataStorageItem {
    public ItemIIFunctionalCircuit() {
        super("circuit_functional", 1, (String[])Arrays.stream(Circuit.values()).map(Circuit::func_176610_l).toArray(String[]::new));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> list, @Nonnull ITooltipFlag flag) {
        list.add(I18n.func_135052_a((String)"desc.immersiveintelligence.functional_circuit", (Object[])new Object[0]));
        for (String s : this.getOperationsList(stack)) {
            list.add("-" + I18n.func_135052_a((String)("datasystem.immersiveintelligence.function." + s), (Object[])new Object[0]));
        }
    }

    @Override
    public DataPacket getStoredData(ItemStack stack) {
        stack.serializeNBT();
        NBTTagCompound realtag = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"operations");
        DataPacket data = new DataPacket();
        data.fromNBT(realtag);
        return data;
    }

    @Override
    public void writeDataToItem(DataPacket packet, ItemStack stack) {
        ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"operations", (NBTTagCompound)packet.toNBT());
    }

    @Override
    public String getDataStorageItemType(ItemStack stack) {
        return "ds_functional_circuit";
    }

    public List<String> getOperationsList(ItemStack stack) {
        if (stack.func_77960_j() < Circuit.values().length) {
            Circuit circuit = Circuit.values()[stack.func_77960_j()];
            return Arrays.asList(circuit.functions);
        }
        return Collections.emptyList();
    }

    public String getTESRRenderTexture(ItemStack stack) {
        if (stack.func_77960_j() < Circuit.values().length) {
            switch (Circuit.values()[stack.func_77960_j()].tier) {
                case 0: {
                    return "redstone_circuits";
                }
                case 1: {
                    return "electronic_circuits";
                }
                case 2: {
                    return "advanced_circuits";
                }
            }
        }
        return "";
    }

    public static enum Circuit implements IStringSerializable
    {
        ARITHMETIC(1, "add", "subtract", "multiply", "divide", "modulo"),
        ADVANCED_ARITHMETIC(2, ARITHMETIC, "power", "root", "min", "max"),
        LOGIC(0, "and", "or", "not"),
        COMPARATOR(1, "greater", "less", "greater_or_equal", "less_or_equal", "equal"),
        ADVANCED_LOGIC(2, LOGIC, "nand", "nor", "xor", "xnor"),
        TEXT(1, "string_join", "string_equal", "string_split", "string_length", "string_char_at", "string_substring", "string_trim", "string_hexcol", "string_format", "string_contains", "string_contains_count", "string_lowercase", "string_uppercase", "string_snake_case", "string_camel_case", "string_reverse"),
        ITEMSTACK(2, "get_quantity", "set_quantity", "get_durability", "set_durability", "get_nbt", "set_nbt", "get_itemstack", "get_item_id", "can_stack_with", "matches_oredict"),
        ARRAY(1, "array_get", "array_pop", "array_push"),
        ENTITY(2, "entity_get_id", "entity_get_type", "entity_get_name", "entity_get_dimension_id", "entity_get_x", "entity_get_y", "entity_get_z"),
        DOCUMENT(2, "document_read_page", "document_read_all_pages_array", "document_read_all_pages_string", "document_get_author", "document_get_title"),
        TYPE_CONVERSION(1, "is_null", "to_integer", "to_string", "to_boolean", "to_null");

        private final String[] functions;
        public final int tier;

        private Circuit(int tier, String ... functions) {
            this.tier = tier;
            this.functions = functions;
        }

        private Circuit(int tier, Circuit parent, String ... functions) {
            this(tier, (String[])ArrayUtils.addAll((Object[])parent.functions, (Object[])functions));
        }

        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

