/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.api.utils.IPrecissionTool;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.PrecissionAssemblerRenderer;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIPrecissionTool
extends ItemIIBase
implements IPrecissionTool {
    public ItemIIPrecissionTool() {
        super("precission_tool", 1, "precission_buzzsaw", "precission_drill", "precission_inserter", "precission_solderer", "precission_welder", "precission_hammer");
        PrecissionAssemblerRecipe.registerToolType("buzzsaw", this);
        PrecissionAssemblerRecipe.registerToolType("drill", this);
        PrecissionAssemblerRecipe.registerToolType("inserter", this);
        PrecissionAssemblerRecipe.registerToolType("solderer", this);
        PrecissionAssemblerRecipe.registerToolType("welder", this);
        PrecissionAssemblerRecipe.registerToolType("hammer", this);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)this.getPrecissionToolMaxDamage(stack));
    }

    @Override
    public String getPrecissionToolType(ItemStack stack) {
        return this.subNames[stack.func_77960_j()].replaceAll("precission_", "");
    }

    @Override
    public void damagePrecissionTool(ItemStack stack, int amount) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)this.getPrecissionToolMaxDamage(stack));
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"damage", (int)(this.getPrecissionToolDamage(stack) - amount));
        if (this.getPrecissionToolDamage(stack) < 0) {
            stack.func_190920_e(0);
        }
    }

    @Override
    public int getPrecissionToolDamage(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage") ? ItemNBTHelper.getInt((ItemStack)stack, (String)"damage") : this.getPrecissionToolMaxDamage(stack);
    }

    @Override
    public int getPrecissionToolMaxDamage(ItemStack stack) {
        switch (this.subNames[stack.func_77960_j()]) {
            case "precission_buzzsaw": {
                return Config.IIConfig.Tools.precission_tool_buzzsaw_durability;
            }
            case "precission_drill": {
                return Config.IIConfig.Tools.precission_tool_drill_durability;
            }
            case "precission_inserter": {
                return Config.IIConfig.Tools.precission_tool_inserter_durability;
            }
            case "precission_solderer": {
                return Config.IIConfig.Tools.precission_tool_solderer_durability;
            }
            case "precission_welder": 
            case "precission_hammer": {
                return Config.IIConfig.Tools.precission_tool_welder_durability;
            }
        }
        return -1;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"info.immersiveintelligence.gear_durability", (Object[])new Object[]{this.getPrecissionToolDamage(stack), this.getPrecissionToolMaxDamage(stack)}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"damage") && (double)this.getPrecissionToolDamage(stack) / (double)this.getPrecissionToolMaxDamage(stack) != 1.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getPrecissionToolDamage(stack) / (double)this.getPrecissionToolMaxDamage(stack);
    }

    @Override
    public int getWorkTime(String tool_name) {
        switch (tool_name) {
            case "buzzsaw": {
                return Config.IIConfig.Tools.precission_tool_buzzsaw_usage_time;
            }
            case "drill": {
                return Config.IIConfig.Tools.precission_tool_drill_usage_time;
            }
            case "inserter": {
                return Config.IIConfig.Tools.precission_tool_inserter_usage_time;
            }
            case "solderer": {
                return Config.IIConfig.Tools.precission_tool_solderer_usage_time;
            }
            case "welder": {
                return Config.IIConfig.Tools.precission_tool_welder_usage_time;
            }
            case "hammer": {
                return Config.IIConfig.Tools.precission_tool_hammer_usage_time;
            }
        }
        return -1;
    }

    @Override
    public ItemStack getToolPresentationStack(String tool_name) {
        return new ItemStack((Item)this, 1, this.getMetaBySubname("precission_" + tool_name));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInMachine(ItemStack stack, float progress, float angle, float maxProgress, ItemStack renderedStack) {
        switch (this.subNames[stack.func_77960_j()]) {
            case "precission_buzzsaw": {
                PrecissionAssemblerRenderer.modelBuzzsaw.renderProgress(progress, angle, maxProgress);
                return;
            }
            case "precission_drill": {
                PrecissionAssemblerRenderer.modelDrill.renderProgress(progress, angle, maxProgress);
                return;
            }
            case "precission_inserter": {
                PrecissionAssemblerRenderer.modelInserter.renderProgress(progress, angle, maxProgress, renderedStack);
                return;
            }
            case "precission_solderer": {
                PrecissionAssemblerRenderer.modelSolderer.renderProgress(progress, angle, maxProgress);
                return;
            }
            case "precission_welder": {
                PrecissionAssemblerRenderer.modelWelder.renderProgress(progress, angle, maxProgress);
                return;
            }
            case "precission_hammer": {
                PrecissionAssemblerRenderer.modelHammer.renderProgress(progress, angle, maxProgress);
            }
        }
    }
}

