/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIITripWireCoil
extends ItemIIBase
implements IWireCoil {
    public static IITripWireType TRIPWIRE = new IITripWireType();
    public static final String TRIPWIRE_CATEGORY = "TRIPWIRE";

    public ItemIITripWireCoil() {
        super("trip_wire", 64, new String[0]);
    }

    public WireType getWireType(ItemStack stack) {
        return TRIPWIRE;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int[] link;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")) != null && link.length > 3) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return ApiUtils.doCoilUse((IWireCoil)this, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumHand)hand, (EnumFacing)side, (float)hitX, (float)hitY, (float)hitZ);
    }

    public static class IITripWireType
    extends WireType {
        public double getLossRatio() {
            return 0.0;
        }

        public int getTransferRate() {
            return 1;
        }

        public int getColour(ImmersiveNetHandler.Connection connection) {
            return Config.IIConfig.Wires.tripwireColouration;
        }

        public double getSlack() {
            return 1.002;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIcon(ImmersiveNetHandler.Connection connection) {
            return iconDefaultWire;
        }

        public int getMaxLength() {
            return Config.IIConfig.Wires.tripwireLength;
        }

        public ItemStack getWireCoil() {
            return new ItemStack((Item)IIContent.itemTripWireCoil, 1, 0);
        }

        public String getUniqueName() {
            return ItemIITripWireCoil.TRIPWIRE_CATEGORY;
        }

        public double getRenderDiameter() {
            return 0.0125f;
        }

        public boolean isEnergyWire() {
            return true;
        }

        public String getCategory() {
            return ItemIITripWireCoil.TRIPWIRE_CATEGORY;
        }

        public double getDamageRadius() {
            return 0.0;
        }

        public boolean canCauseDamage() {
            return true;
        }

        public IElectricEquipment.ElectricSource getElectricSource() {
            return super.getElectricSource();
        }
    }
}

