/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.armor;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.util.IIArmorItemStackHandler;

public abstract class ItemIIUpgradeableArmor
extends ItemArmor
implements IUpgradeableTool {
    static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    String upgradeType;
    public static final String NBT_Colour = "colour";

    public ItemIIUpgradeableArmor(ItemArmor.ArmorMaterial materialIn, EntityEquipmentSlot equipmentSlotIn, String upgradeType) {
        super(materialIn, -1, equipmentSlotIn);
        this.upgradeType = upgradeType;
        String name = (this.getMaterialName(this.func_82812_d()) + "_" + this.getNameForPart(equipmentSlotIn)).replace("immersiveintelligence:", "");
        this.func_77655_b("immersiveintelligence." + name);
        this.func_77637_a(ImmersiveIntelligence.creativeTab);
        this.func_77625_d(1);
        IIContent.ITEMS.add((Item)this);
    }

    abstract String getMaterialName(ItemArmor.ArmorMaterial var1);

    public static boolean isArmorWithUpgrade(ItemStack stack, String upgrade) {
        return stack.func_77973_b() instanceof ItemIIUpgradeableArmor && ((ItemIIUpgradeableArmor)stack.func_77973_b()).getUpgrades(stack).func_74764_b(upgrade);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        float durability = 100.0f - (float)this.getDurabilityForDisplay(stack) * 100.0f;
        tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.durability", (Object[])new Object[]{durability + "%"}));
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)NBT_Colour)) {
            String hexCol = Integer.toHexString(this.func_82814_b(stack));
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
        }
    }

    public int func_82814_b(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)NBT_Colour)) {
            return ItemNBTHelper.getInt((ItemStack)stack, (String)NBT_Colour);
        }
        return 0xFFFFFF;
    }

    protected String getNameForPart(EntityEquipmentSlot equipmentSlotIn) {
        switch (equipmentSlotIn) {
            case HEAD: {
                return "helmet";
            }
            case CHEST: {
                return "chestplate";
            }
            case LEGS: {
                return "leggings";
            }
        }
        return "boots";
    }

    public NBTTagCompound getUpgrades(ItemStack stack) {
        return ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"upgrades");
    }

    public void clearUpgrades(ItemStack stack) {
        ItemNBTHelper.remove((ItemStack)stack, (String)"upgrades");
    }

    public void finishUpgradeRecalculation(ItemStack stack) {
    }

    public void recalculateUpgrades(ItemStack stack) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.clearUpgrades(stack);
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        NBTTagCompound upgradeTag = this.getUpgradeBase(stack).func_74737_b();
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                IUpgrade upg;
                ItemStack u = inv.getStackInSlot(i);
                if (u.func_190926_b() || !(u.func_77973_b() instanceof IUpgrade) || !(upg = (IUpgrade)u.func_77973_b()).getUpgradeTypes(u).contains(this.upgradeType) || !upg.canApplyUpgrades(stack, u)) continue;
                upg.applyUpgrades(stack, u, upgradeTag);
            }
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"upgrades", (NBTTagCompound)upgradeTag);
            this.finishUpgradeRecalculation(stack);
        }
    }

    public NBTTagCompound getUpgradeBase(ItemStack stack) {
        return new NBTTagCompound();
    }

    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ArrayList<IESlot.Upgrades> upgrades = new ArrayList<IESlot.Upgrades>();
        for (int i = 0; i < this.getSlotCount(); ++i) {
            upgrades.add(new IESlot.Upgrades(container, inv, i, 80 + i * 20, 32, this.upgradeType, stack, true));
        }
        return (Slot[])upgrades.toArray(new IESlot.Upgrades[0]);
    }

    public int getSlotCount() {
        return 2;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IIArmorItemStackHandler(stack);
        }
        return null;
    }

    public void setContainedItems(ItemStack stack, NonNullList<ItemStack> inventory) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler instanceof IItemHandlerModifiable) {
            if (inventory.size() != handler.getSlots()) {
                throw new IllegalArgumentException("Parameter inventory has " + inventory.size() + " slots, capability inventory has " + handler.getSlots());
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ((IItemHandlerModifiable)handler).setStackInSlot(i, (ItemStack)inventory.get(i));
            }
        } else {
            IELogger.warn((Object)("No valid inventory handler found for " + stack));
        }
    }

    public NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler instanceof IIArmorItemStackHandler) {
            return ((IIArmorItemStackHandler)handler).getContainedItems();
        }
        if (handler != null) {
            IELogger.warn((Object)("Inefficiently getting contained items. Why does " + stack + " have a non-IE IItemHandler?"));
            NonNullList inv = NonNullList.func_191197_a((int)handler.getSlots(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < handler.getSlots(); ++i) {
                inv.set(i, (Object)handler.getStackInSlot(i));
            }
            return inv;
        }
        IELogger.info((Object)("No valid inventory handler found for " + stack));
        return NonNullList.func_191196_a();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"Inv")) {
            NBTTagList list = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("Inv", 10);
            this.setContainedItems(stack, (NonNullList<ItemStack>)Utils.readInventory((NBTTagList)list, (int)this.getSlotCount()));
            ItemNBTHelper.remove((ItemStack)stack, (String)"Inv");
            if (entityIn instanceof EntityPlayerMP && !worldIn.field_72995_K) {
                ((EntityPlayerMP)entityIn).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-2, itemSlot, stack));
            }
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == this.field_77881_a) {
            NBTTagCompound nbt = this.getUpgrades(stack);
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.field_77879_b + nbt.func_74769_h("armor_increase"), 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Toughness modifier", (double)this.field_189415_e + nbt.func_74769_h("toughness_increase"), 0));
        }
        return multimap;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "immersiveintelligence:textures/armor/empty.png";
    }

    public boolean hasOverlay(ItemStack stack) {
        return false;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }
}

