/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.weapons;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.CustomSkinHandler;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.ISkinnable;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.client.ClientProxy;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageItemReloadMagazine;
import pl.pabilo8.immersiveintelligence.common.network.MessageParticleGunfire;

public class ItemIISubmachinegun
extends ItemUpgradeableTool
implements IEItemInterfaces.IAdvancedFluidItem,
ISkinnable {
    public ItemIISubmachinegun() {
        super("submachinegun", 1, "SUBMACHINEGUN", new String[0]);
        this.fixupItem();
    }

    public int getSlotCount(ItemStack stack) {
        return 3;
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "SUBMACHINEGUN", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 32, "SUBMACHINEGUN", stack, true), new IESlot.Upgrades(container, inv, 2, 120, 32, "SUBMACHINEGUN", stack, true)};
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String skin = this.getSkinnableCurrentSkin(stack);
        if (!skin.isEmpty() && CustomSkinHandler.specialSkins.containsKey(skin)) {
            tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)String.format("skin.%1$s.%2$s.name", "immersiveintelligence", skin), (Object[])new Object[0]));
            tooltip.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)String.format("skin.%1$s.%2$s.desc", "immersiveintelligence", skin), (Object[])new Object[0]));
        }
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        String skin = this.getSkinnableCurrentSkin(stack);
        if (!skin.isEmpty() && CustomSkinHandler.specialSkins.containsKey(skin)) {
            return CustomSkinHandler.specialSkins.get((Object)skin).rarity;
        }
        return super.getForgeRarity(stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean b;
        boolean bl = b = !(entityIn instanceof EntityLivingBase) || !((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.MAINHAND).equals(stack);
        if (b) {
            return;
        }
        if (isSelected) {
            float recoilH = ItemNBTHelper.getFloat((ItemStack)stack, (String)"recoilH");
            float recoilV = ItemNBTHelper.getFloat((ItemStack)stack, (String)"recoilV");
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"recoilH", (float)MathHelper.func_76131_a((float)(recoilH - Math.signum(recoilH) * Math.min(Math.abs(recoilH), 1.0f)), (float)(-Config.IIConfig.Weapons.Submachinegun.recoilHorizontal), (float)Config.IIConfig.Weapons.Submachinegun.recoilHorizontal));
            ItemNBTHelper.setFloat((ItemStack)stack, (String)"recoilV", (float)MathHelper.func_76131_a((float)(recoilV - Math.signum(recoilV) * Math.min(Math.abs(recoilV), 1.0f)), (float)(-Config.IIConfig.Weapons.Submachinegun.recoilVertical), (float)Config.IIConfig.Weapons.Submachinegun.recoilVertical));
            if (worldIn.field_72995_K && !ItemNBTHelper.getBoolean((ItemStack)stack, (String)"shouldReload") && ClientProxy.keybind_manualReload.func_151470_d()) {
                IIPacketHandler.INSTANCE.sendToServer((IMessage)new MessageItemReloadMagazine());
            }
            int currentAim = ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming");
            int fireDelay = ItemNBTHelper.getInt((ItemStack)stack, (String)"fireDelay");
            int reloading = ItemNBTHelper.getInt((ItemStack)stack, (String)"reloading");
            boolean shouldReload = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"shouldReload");
            if (shouldReload) {
                ItemStack magazine = ItemNBTHelper.getItemStack((ItemStack)stack, (String)"magazine");
                if (reloading == 1) {
                    worldIn.func_184148_a(null, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, magazine.func_190926_b() ? IISounds.submachinegun_reload : IISounds.submachinegun_unload, SoundCategory.PLAYERS, 0.35f, 1.0f);
                }
                if (!magazine.func_190926_b()) {
                    if (++reloading >= (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"isDrum") ? Config.IIConfig.Weapons.Submachinegun.drumReloadTime : Config.IIConfig.Weapons.Submachinegun.clipReloadTime)) {
                        shouldReload = false;
                        reloading = 0;
                        if (!worldIn.field_72995_K) {
                            ItemIIBulletMagazine.makeDefault(magazine);
                            if (entityIn.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                                IItemHandler capability = (IItemHandler)entityIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                                magazine = ItemHandlerHelper.insertItem((IItemHandler)capability, (ItemStack)magazine, (boolean)false);
                            }
                            if (!magazine.func_190926_b()) {
                                blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)worldIn, (BlockPos)entityIn.func_180425_c(), (ItemStack)magazine);
                            }
                            ItemNBTHelper.remove((ItemStack)stack, (String)"magazine");
                        }
                    }
                } else if (!this.findMagazine(entityIn, stack).func_190926_b()) {
                    ItemNBTHelper.setBoolean((ItemStack)stack, (String)"isDrum", (this.findMagazine(entityIn, stack).func_77960_j() == 3 ? 1 : 0) != 0);
                    if (++reloading >= (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"isDrum") ? Config.IIConfig.Weapons.Submachinegun.drumReloadTime : Config.IIConfig.Weapons.Submachinegun.clipReloadTime)) {
                        shouldReload = false;
                        reloading = 0;
                        if (!worldIn.field_72995_K && !(magazine = this.findMagazine(entityIn, stack)).func_190926_b()) {
                            ItemNBTHelper.setItemStack((ItemStack)stack, (String)"magazine", (ItemStack)magazine);
                            magazine.func_190918_g(1);
                        }
                    }
                } else {
                    shouldReload = false;
                    reloading = 0;
                }
            } else {
                reloading = 0;
            }
            ItemNBTHelper.setInt((ItemStack)stack, (String)"reloading", (int)reloading);
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"shouldReload", (boolean)shouldReload);
            boolean foldingStock = this.getUpgrades(stack).func_74764_b("folding_stock");
            if (reloading == 0 && entityIn.func_70093_af()) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"aiming", (int)MathHelper.func_76125_a((int)(currentAim + 1), (int)0, (int)(foldingStock ? Config.IIConfig.Weapons.Submachinegun.aimTimeFoldedStock : Config.IIConfig.Weapons.Submachinegun.aimTime)));
            } else if (currentAim > 0) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"aiming", (int)MathHelper.func_76125_a((int)(currentAim - 3), (int)0, (int)(foldingStock ? Config.IIConfig.Weapons.Submachinegun.aimTimeFoldedStock : Config.IIConfig.Weapons.Submachinegun.aimTime)));
            }
            if (fireDelay > 0) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"fireDelay", (int)(fireDelay - 1));
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void onUsingTick(@Nonnull ItemStack stack, EntityLivingBase player, int count) {
        World worldIn = player.func_130014_f_();
        ItemStack magazine = ItemNBTHelper.getItemStack((ItemStack)stack, (String)"magazine");
        if (!this.isAmmo(magazine, stack)) {
            return;
        }
        if (ItemNBTHelper.getInt((ItemStack)stack, (String)"fireDelay") == 0) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"fireDelay", (int)Config.IIConfig.Weapons.Submachinegun.bulletFireTime);
            if (!worldIn.field_72995_K) {
                float signum;
                boolean foldingStock = this.getUpgrades(stack).func_74764_b("folding_stock");
                boolean isAimed = (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"aiming") > (foldingStock ? (double)Config.IIConfig.Weapons.Submachinegun.aimTimeFoldedStock : (double)Config.IIConfig.Weapons.Submachinegun.aimTime * 0.9);
                float recoilH = ItemNBTHelper.getFloat((ItemStack)stack, (String)"recoilH");
                float recoilV = ItemNBTHelper.getFloat((ItemStack)stack, (String)"recoilV");
                Vec3d vec = Utils.getVectorForRotation(player.field_70125_A - recoilH, player.func_70079_am() + recoilV);
                Vec3d vv = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e() - (double)0.1f, 0.0);
                ItemStack s2 = ItemIIBulletMagazine.takeBullet(magazine, true);
                boolean sturdyBarrel = this.getUpgrades(stack).func_74764_b("sturdy_barrel");
                EntityBullet a = BulletHelper.createBullet(worldIn, s2, vv, vec, sturdyBarrel ? Config.IIConfig.Weapons.Submachinegun.sturdyBarrelVelocityMod : 1.0f);
                a.setShooters((Entity)player, new Entity[0]);
                worldIn.func_72838_d((Entity)a);
                boolean supressor = this.getUpgrades(stack).func_74764_b("suppressor");
                float noise = supressor ? 0.25f : 1.0f;
                blusunrize.immersiveengineering.common.util.Utils.attractEnemies((EntityLivingBase)player, (float)(36.0f * noise));
                worldIn.func_184148_a(null, player.field_70165_t + vec.field_72450_a, player.field_70163_u + vec.field_72448_b, player.field_70161_v + vec.field_72449_c, IISounds.submachinegun_shot, SoundCategory.PLAYERS, 1.5f * noise, supressor ? 0.75f : 0.0f);
                IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageParticleGunfire((Entity)player, supressor ? 0.5f : 1.5f), Utils.targetPointFromEntity((Entity)player, 32));
                if (count % 3 == 0) {
                    signum = Math.signum(recoilV);
                    recoilV = MathHelper.func_76131_a((float)(Math.abs(recoilV) + (isAimed ? 0.65f * Config.IIConfig.Weapons.Submachinegun.recoilVertical : Config.IIConfig.Weapons.Submachinegun.recoilVertical)), (float)0.0f, (float)Config.IIConfig.Weapons.Submachinegun.maxRecoilVertical);
                    ItemNBTHelper.setFloat((ItemStack)stack, (String)"recoilV", (float)(recoilV *= signum > 0.0f ? -1.0f : 1.0f));
                } else {
                    signum = Math.signum(recoilV);
                    recoilH = MathHelper.func_76131_a((float)(Math.abs(recoilH) + (isAimed ? 0.65f * Config.IIConfig.Weapons.Submachinegun.recoilHorizontal : Config.IIConfig.Weapons.Submachinegun.recoilHorizontal)), (float)0.0f, (float)(Config.IIConfig.Weapons.Submachinegun.maxRecoilHorizontal * -Math.signum(recoilH)));
                    ItemNBTHelper.setFloat((ItemStack)stack, (String)"recoilH", (float)(recoilH *= signum > 0.0f ? -1.0f : 1.0f));
                }
                ItemStack cc = ((IBullet)s2.func_77973_b()).getCasingStack(1);
                if (player.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    IItemHandler capability = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    cc = ItemHandlerHelper.insertItem((IItemHandler)capability, (ItemStack)cc, (boolean)false);
                }
                if (!cc.func_190926_b()) {
                    blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)worldIn, (BlockPos)player.func_180425_c(), (ItemStack)cc);
                }
            }
        }
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return Config.IIConfig.Weapons.Submachinegun.bulletFireTime + 1;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND) {
            player.func_184598_c(hand);
            if (this.isAmmo(ItemNBTHelper.getItemStack((ItemStack)itemstack, (String)"magazine"), itemstack)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entityLiving, int timeLeft) {
    }

    public void fixupItem() {
        Item rItem = (Item)IEContent.registeredIEItems.remove(IEContent.registeredIEItems.size() - 1);
        if (rItem != this) {
            throw new IllegalStateException("fixupItem was not called at the appropriate time");
        }
        this.func_77655_b("immersiveintelligence." + this.itemName);
        this.func_77637_a(ImmersiveIntelligence.creativeTab);
        IIContent.ITEMS.add((Item)this);
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack) {
        double melee;
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && (melee = (double)this.getUpgrades(stack).func_74760_g("melee")) != 0.0) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", melee, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public int getCapacity(ItemStack stack, int baseCapacity) {
        return 0;
    }

    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return false;
    }

    @Override
    public String getSkinnableDefaultTextureLocation() {
        return "immersiveintelligence:textures/items/weapons/";
    }

    public ItemStack findMagazine(Entity entity, ItemStack weapon) {
        if (!(entity instanceof EntityLivingBase)) {
            return ItemStack.field_190927_a;
        }
        if (entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (capability == null) {
                return ItemStack.field_190927_a;
            }
            for (int i = 0; i < capability.getSlots(); ++i) {
                ItemStack itemstack = capability.getStackInSlot(i);
                if (!this.isAmmo(itemstack, weapon)) continue;
                return itemstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean isAmmo(ItemStack stack, ItemStack weapon) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemIIBulletMagazine) {
            return ItemIIBulletMagazine.getMatchingType(stack) == IIContent.itemAmmoSubmachinegun && !ItemIIBulletMagazine.hasNoBullets(stack) && (stack.func_77960_j() != 3 || this.getUpgrades(weapon).func_74764_b("bottom_loading"));
        }
        return false;
    }
}

