/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMotorbike;

public class MessageParticleEffect
implements IMessage {
    String id;
    public double x;
    public double y;
    public double z;

    public MessageParticleEffect(double x, double y, double z, String id) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.id = id;
    }

    public MessageParticleEffect() {
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.id = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.id);
    }

    public static class HandlerClient
    implements IMessageHandler<MessageParticleEffect, IMessage> {
        public IMessage onMessage(MessageParticleEffect message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null) {
                    switch (message.id) {
                        case "white_phosphorus": {
                            ParticleUtils.spawnExplosionPhosphorusFX(message.x, message.y, message.z);
                            break;
                        }
                        case "motorbike_explosion": {
                            Entity e = world.func_73045_a((int)message.x);
                            if (!(e instanceof EntityMotorbike)) break;
                            EntityMotorbike motorbike = (EntityMotorbike)e;
                            motorbike.selfDestruct();
                            break;
                        }
                        case "gunfire": {
                            ParticleUtils.spawnGunfireFX(message.x, message.y, message.z, 0.0, 0.0, 0.0, 8.0f);
                        }
                    }
                }
            });
            return null;
        }
    }
}

