/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.wire;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.common.IIContent;

public class IISmallWireType
extends WireType {
    public static IISmallWireType SMALL_REDSTONE;
    public static IISmallWireType SMALL_DATA;
    public String name;
    public int meta;

    public IISmallWireType(String name, int meta) {
        this.name = name;
        this.meta = meta;
    }

    public static void init() {
        SMALL_REDSTONE = new IISmallWireType("redstone", 0);
        SMALL_DATA = new IISmallWireType("data", 1);
    }

    public double getLossRatio() {
        return 0.0;
    }

    public int getTransferRate() {
        return 0;
    }

    public int getColour(ImmersiveNetHandler.Connection connection) {
        return this.meta == 0 ? Config.IIConfig.Wires.smallDataWireColouration : Config.IIConfig.Wires.smallRedstoneWireColouration;
    }

    public double getSlack() {
        return 1.002;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getIcon(ImmersiveNetHandler.Connection connection) {
        return iconDefaultWire;
    }

    public int getMaxLength() {
        return this.meta == 0 ? Config.IIConfig.Wires.smallDataWireLength : Config.IIConfig.Wires.smallRedstoneWireLength;
    }

    public ItemStack getWireCoil() {
        return new ItemStack((Item)IIContent.itemSmallWireCoil, 1, this.meta);
    }

    public String getUniqueName() {
        return this.name;
    }

    public double getRenderDiameter() {
        return 0.03125;
    }

    public boolean isEnergyWire() {
        return false;
    }

    public String getCategory() {
        return this.name.toUpperCase();
    }

    public double getDamageRadius() {
        return 0.0;
    }

    public boolean canCauseDamage() {
        return false;
    }
}

