"use strict";

var path = require ("path");
var isGlobal = require ("is-global");

var WIN = process.platform === "win32";
if (!path.sep) path.sep = process.platform === "win32" ? "\\" : "/";

var meta = module.exports = function (p){
	var normalized = path.normalize (p);
	var prefix = "";
	var normalizedWithoutPrefix = normalized;
	
	//Prefix, D:, smb:, etc
	var index = normalized.indexOf (":") + 1;
	if (index){
		prefix = normalized.substring (0, index);
		normalizedWithoutPrefix = normalized.substring (index);
	}
	
	//Network resource (UNC)
	var start = p.substring (index, index + 2);
	var isNetwork = start === "//" || start === "\\\\";
	
	var isAbsolute = false;
	var homePath = false;
	
	if (isNetwork){
		if (WIN){
			//UNC bugs covered
			//https://github.com/joyent/node/issues/3066
			//https://github.com/joyent/node/issues/3610
			if (normalized.substring (index, index + 2) === "//"){
				normalizedWithoutPrefix =
						normalizedWithoutPrefix.replace (/\//g, "\\");
			}
			var i = 0;
			while (normalizedWithoutPrefix[i] === "\\") i++;
			normalizedWithoutPrefix = "\\\\" + (i === 2
					//Extra trailing slash
					? normalizedWithoutPrefix.substring (i,
							normalizedWithoutPrefix.length - 1)
					: normalizedWithoutPrefix.substring (i));
			//Add last slash if necessary
			var last = p[p.length - 1];
			if ((last === "\\" || last === "/") && i === 2){
				normalizedWithoutPrefix += "\\";
			}
		}else{
			//If Linux, both //a/a and //a//a return /a/a
			normalizedWithoutPrefix = "/" + normalizedWithoutPrefix;
		}
		normalized = prefix + normalizedWithoutPrefix;
	}else{
		//Absolute path from root or from home path (Linux)
		if (normalizedWithoutPrefix.substring (0, 2) === "~" + path.sep){
			//Linux relative home path is resolved to an absolute path because
			//Node.js built-in fs functions don't accept a home path
			homePath = true;
			if (!WIN){
				normalized = process.env.HOME + normalizedWithoutPrefix.substring (1);
			}
		}else if (normalizedWithoutPrefix[0] === path.sep){
			//Absolute
			isAbsolute = true;
		}
	}
	
	var isRelative = !isNetwork && !isAbsolute;
	
	var o = {
		isAbsolute: isAbsolute,
		isNetwork: isNetwork,
		isRelative: isRelative,
		normalized: normalized
	};
	
	if (homePath) return o;
	
	o.prefix = prefix;
	
	if (!WIN && prefix.length &&
			normalizedWithoutPrefix.substring (0, 2) === "./"){
		//On Linux, if prefix is found ./a/b is not normalized to a/b
		normalizedWithoutPrefix = normalizedWithoutPrefix.substring (2);
		o.normalized = prefix + normalizedWithoutPrefix;
	}
	
	o.normalizedWithoutPrefix = normalizedWithoutPrefix;
	
	if (isRelative){
		o.relativeFix = meta.fix ();
		o.normalizedFixedWithoutPrefix = o.relativeFix +
				(o.relativeFix.length ? path.sep : "") +	normalizedWithoutPrefix;
		o.normalizedFixed = prefix + o.normalizedFixedWithoutPrefix;
	}
	
	return o;
};

meta.fix = function (){
	return isGlobal ()
				? ""
				: path.relative (process.cwd (), 
						path.dirname (process.mainModule.filename));
};