
// 绘制阴影图片
function shadow(){
    // 首先获取ID为'box'的元素
    var box = document.getElementById('box');
    // 创建一个新的canvas元素
    var canvas = document.createElement('canvas');

    // 设置canvas的ID
    canvas.id = 'shadow';

    // 设置canvas的宽度和高度
    var canvas_width = Math.floor(document.getElementById("img").offsetWidth-2);
    var canvas_height = Math.floor(document.getElementById("img").offsetHeight-2);
    canvas.width = canvas_width + 70;
    canvas.height = canvas_height + 60;

    // 将canvas添加到box元素中
    box.appendChild(canvas);

    var canvas = document.getElementById("shadow");

    canvas.style.marginLeft= parseFloat(window.getComputedStyle(document.getElementById('img')).marginLeft)-40 +'px';
    canvas.style.marginTop= 0+parseFloat(window.getComputedStyle(document.getElementById('img')).marginTop)-document.getElementById('box').getBoundingClientRect().height -30 +'px';

    var ctx = canvas.getContext('2d');
    // 清空 canvas
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    var alpha = (document.getElementById("range_shadow").value/100).toString();
    var shadow_radius = document.getElementById("range_radius").value.toString();
    document.getElementById('img').style.boxShadow = 'none';
    rasterizeHTML.drawHTML('<body style="margin:0px;padding:0px"><div style="width:'+ canvas_width +'px;height:'+ canvas_height +'px;box-shadow:0px 8px 20px 0px rgba(0, 0, 0, '+ alpha +');;border-radius:'+ shadow_radius +'px;margin:30px 30px 30px 40px;padding:0px;">' + '</div></body>',
        canvas);
    document.getElementById('export_load').style.display = 'block';
}

const downloadbutton = document.getElementById('downloadButton');

downloadbutton.addEventListener('click', () => {
    shadow();
    var scal_size = document.getElementById('img').naturalWidth/668*800;
    if (scal_size < 800) {
        scal_size = 2;
    }else{
        scal_size = document.getElementById('img').naturalWidth/668;
    }
    document.getElementById('box').style.transform = 'scale('+ scal_size +')';

    // 将 html2canvas 的调用包裹在 setTimeout 中，设置延迟为 100ms
    setTimeout(function() {
        html2canvas(document.querySelector(".box"), {  
            scale: 1, 
            backgroundColor: null,
            onclone: (documentClone) => {
              let element = documentClone.querySelector(".box");
              element.style.backgroundClip = 'padding-box';
            }
          }).then(function (canvas) {
            document.body.appendChild(canvas);
            window.myGlobalVar = canvas.toDataURL('image/png');
            const image_url = [window.myGlobalVar, "download"];
            window.api.setTitle(image_url);
            window.close();
        });
    }, 50); // 延迟设置为 100 毫秒
})


const copyimagebutton = document.getElementById('copy_close');

copyimagebutton.addEventListener('click', () => {
    shadow();
    var scal_size = document.getElementById('img').naturalWidth / 668 * 800;
    if (scal_size < 800) {
        scal_size = 2;
    } else {
        scal_size = document.getElementById('img').naturalWidth/668;
    }
    console.log(scal_size);
    console.log(document.getElementById('img').naturalWidth);
    document.getElementById('box').style.transform = 'scale('+ scal_size +')';

    // 将 html2canvas 的调用包裹在 setTimeout 中，设置延迟为 100ms
    setTimeout(function() {
        html2canvas(document.querySelector(".box"), {
            scale: 1,
            backgroundColor: null,
            onclone: (documentClone) => {
                let element = documentClone.querySelector(".box");
                element.style.backgroundClip = 'padding-box';
            }
        }).then(function(canvas) {
            document.body.appendChild(canvas);
            window.myGlobalVar = canvas.toDataURL('image/png');
            const image_url = [window.myGlobalVar, "copy"];
            window.api.setTitle(image_url);
            window.close();
        });
    }, 50); // 延迟设置为 100 毫秒

})


function screenshot_urlset(){
    var canvas = document.getElementById('myCanvas');
    window.myGlobalVar = canvas.toDataURL('image/png');
    const image_url = [window.myGlobalVar, "screenshot"];
    window.api.setTitle(image_url);
    window.close();
}