/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan;

import java.security.Security;
import java.util.Locale;
import java.util.logging.Logger;
import net.azib.ipscan.config.CommandLineProcessor;
import net.azib.ipscan.config.ComponentRegistry;
import net.azib.ipscan.config.Config;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.di.Injector;
import net.azib.ipscan.gui.GUI;
import net.azib.ipscan.gui.InfoDialog;
import net.azib.ipscan.gui.MacApplicationMenu;
import net.azib.ipscan.util.GoogleAnalytics;

public class Main {
    static final Logger LOG = LoggerFactory.getLogger();

    public static void main(String ... args) {
        GUI gui = null;
        try {
            long startTime = System.currentTimeMillis();
            gui = new GUI();
            Main.disableDNSCache();
            Locale locale = Config.getConfig().getLocale();
            Labels.initialize(locale);
            LOG.finer("Labels and Config initialized after " + (System.currentTimeMillis() - startTime));
            Injector injector = new ComponentRegistry().init();
            if (Platform.MAC_OS) {
                injector.require(MacApplicationMenu.class);
            }
            LOG.finer("Components initialized after " + (System.currentTimeMillis() - startTime));
            Main.processCommandLine(args, injector);
            gui.showMainWindow(injector);
            Config.getConfig().store();
            gui.close();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            new GoogleAnalytics().report(e);
            Main.swingErrorDialog("Failed to load native code: " + e.getMessage() + "\n\nProbably you are using a binary built for wrong OS or CPU. If 64-bit binary doesn't work for you, try 32-bit version, or vice versa.");
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            new GoogleAnalytics().report(e);
            Main.swingErrorDialog("SWT GUI toolkit not available: " + e.toString() + "\n\nIf you are using platform-neutral build, make sure you provide SWT built for your platform manually (e.g. install libswt packages), or please use a platform specific binary.");
        }
        catch (Throwable e) {
            Main.handleFatalError(gui, e);
        }
    }

    private static void handleFatalError(GUI gui, Throwable e) {
        e.printStackTrace();
        new GoogleAnalytics().report(e);
        if (gui != null) {
            gui.showMessage(0, "Fatal Error", e + "\nPlease submit a bug report mentioning your OS and what exactly were you doing.");
        } else {
            Main.swingErrorDialog(e.getMessage());
        }
    }

    private static void swingErrorDialog(String message) {
        try {
            Class.forName("javax.swing.JOptionPane").getMethod("showMessageDialog", Class.forName("java.awt.Component"), Object.class).invoke(null, null, message);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.err.println(message);
        }
    }

    private static void disableDNSCache() {
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
    }

    private static void processCommandLine(String[] args, Injector injector) {
        if (args.length != 0) {
            CommandLineProcessor cli = injector.require(CommandLineProcessor.class);
            try {
                cli.parse(args);
            }
            catch (Exception e) {
                Main.showMessageToConsole(e.getMessage() + "\n\n" + cli);
                System.exit(1);
            }
        }
    }

    private static void showMessageToConsole(String usageText) {
        if (System.console() != null) {
            System.err.println(usageText);
        } else {
            InfoDialog dialog = new InfoDialog("Angry IP Scanner", Labels.getLabel("title.commandline"));
            dialog.setMessage(usageText);
            dialog.open();
        }
    }
}

