/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.net.InetAddress;
import java.util.prefs.Preferences;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultList;

public class CommentsConfig {
    private Preferences preferences;

    public CommentsConfig(Preferences preferences) {
        this.preferences = preferences.node("comments");
    }

    public String getComment(InetAddress address, String mac) {
        String comment = null;
        if (mac != null) {
            comment = this.preferences.get(mac, null);
        }
        if (comment == null) {
            comment = this.preferences.get(address.getHostAddress(), null);
        }
        return comment;
    }

    public String getComment(ScanningResultList results, int resultIndex) {
        ScanningResult result = results.getResult(resultIndex);
        int macIndex = results.getFetcherIndex("fetcher.mac");
        return this.getComment(result.getAddress(), this.getMac(macIndex, result));
    }

    private String getMac(int macIndex, ScanningResult result) {
        if (macIndex < 0) {
            return null;
        }
        Object macValue = result.getValues().get(macIndex);
        return macValue instanceof String ? (String)macValue : null;
    }

    public void setComment(ScanningResultList results, int resultIndex, String comment) {
        ScanningResult result = results.getResult(resultIndex);
        int macIndex = results.getFetcherIndex("fetcher.mac");
        String key = result.getAddress().getHostAddress();
        if (macIndex >= 0) {
            this.preferences.remove(key);
            String mac = this.getMac(macIndex, result);
            if (mac != null) {
                key = mac;
            }
        }
        if (comment == null || comment.length() == 0) {
            this.preferences.remove(key);
        } else {
            this.preferences.put(key, comment);
        }
    }
}

