/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import net.azib.ipscan.config.ConfigModule;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.PluginLoader;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.di.Injector;
import net.azib.ipscan.exporters.CSVExporter;
import net.azib.ipscan.exporters.IPListExporter;
import net.azib.ipscan.exporters.TXTExporter;
import net.azib.ipscan.exporters.XMLExporter;
import net.azib.ipscan.feeders.FeederRegistry;
import net.azib.ipscan.fetchers.CommentFetcher;
import net.azib.ipscan.fetchers.FilteredPortsFetcher;
import net.azib.ipscan.fetchers.HTTPProxyFetcher;
import net.azib.ipscan.fetchers.HTTPSenderFetcher;
import net.azib.ipscan.fetchers.HostnameFetcher;
import net.azib.ipscan.fetchers.IPFetcher;
import net.azib.ipscan.fetchers.MACFetcher;
import net.azib.ipscan.fetchers.MACVendorFetcher;
import net.azib.ipscan.fetchers.NetBIOSInfoFetcher;
import net.azib.ipscan.fetchers.PacketLossFetcher;
import net.azib.ipscan.fetchers.PingFetcher;
import net.azib.ipscan.fetchers.PingTTLFetcher;
import net.azib.ipscan.fetchers.PortsFetcher;
import net.azib.ipscan.fetchers.UnixMACFetcher;
import net.azib.ipscan.fetchers.WebDetectFetcher;
import net.azib.ipscan.fetchers.WinMACFetcher;
import net.azib.ipscan.gui.SWTAwareStateMachine;
import net.azib.ipscan.gui.feeders.ControlsArea;
import net.azib.ipscan.gui.feeders.FeederGUIRegistry;
import net.azib.ipscan.gui.feeders.FeederSelectionCombo;
import net.azib.ipscan.gui.feeders.FileFeederGUI;
import net.azib.ipscan.gui.feeders.RandomFeederGUI;
import net.azib.ipscan.gui.feeders.RangeFeederGUI;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class ComponentRegistry {
    public void register(Injector i) {
        Display display = Display.getDefault();
        i.register(Display.class, display);
        Shell shell = new Shell();
        i.register(Shell.class, shell);
        i.register(Menu.class, new Menu(shell, 2));
        i.register(FeederSelectionCombo.class, new FeederSelectionCombo(i.require(ControlsArea.class)));
        i.register(Button.class, new Button(i.require(ControlsArea.class), 0));
        SWTAwareStateMachine stateMachine = new SWTAwareStateMachine(display);
        i.register(SWTAwareStateMachine.class, stateMachine);
        i.register(StateMachine.class, stateMachine);
        i.register(RangeFeederGUI.class, RandomFeederGUI.class, FileFeederGUI.class);
        i.register(TXTExporter.class, CSVExporter.class, XMLExporter.class, IPListExporter.class);
        i.register(IPFetcher.class, PingFetcher.class, PingTTLFetcher.class, HostnameFetcher.class, PortsFetcher.class, FilteredPortsFetcher.class, WebDetectFetcher.class, HTTPSenderFetcher.class, CommentFetcher.class, NetBIOSInfoFetcher.class, PacketLossFetcher.class, HTTPProxyFetcher.class);
        i.register(MACFetcher.class, Platform.WINDOWS ? new WinMACFetcher() : new UnixMACFetcher());
        i.register(MACVendorFetcher.class);
        i.register(FeederRegistry.class, (FeederRegistry)i.require(FeederGUIRegistry.class));
    }

    public Injector init() {
        Injector i = new Injector();
        new ConfigModule().register(i);
        new ComponentRegistry().register(i);
        new PluginLoader().getClasses().forEach(i::require);
        return i;
    }
}

