/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.logging.Logger;

public final class Labels {
    public static final String[] LANGUAGES = new String[]{"system", "en", "ru", "de", "hu", "lt", "es", "fr", "it", "ku", "tr", "gr", "pt_BR", "zh_CN", "zh_TW"};
    private static final Logger LOG = Logger.getLogger(Labels.class.getName());
    private static Labels instance;
    PropertyResourceBundle labels;
    PropertyResourceBundle labelsFallback;
    Locale locale;

    Labels() {
    }

    public static Labels getInstance() {
        return instance;
    }

    public static void initialize(Locale locale) {
        InputStream labelsStream;
        if (instance != null && locale.equals(Labels.instance.locale)) {
            return;
        }
        instance = new Labels();
        Labels.instance.locale = locale;
        try {
            labelsStream = Labels.class.getClassLoader().getResourceAsStream("messages.properties");
            try {
                if (labelsStream == null) {
                    throw new MissingResourceException("Labels not found!", Labels.class.getName(), "messages");
                }
                Labels.instance.labelsFallback = new PropertyResourceBundle(new InputStreamReader(labelsStream, "UTF-8"));
            }
            finally {
                if (labelsStream != null) {
                    labelsStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new MissingResourceException(e.toString(), Labels.class.getName(), "messages");
        }
        try {
            labelsStream = Labels.class.getClassLoader().getResourceAsStream("messages_" + locale.toString() + ".properties");
            try {
                Labels.instance.labels = new PropertyResourceBundle(new InputStreamReader(labelsStream, "UTF-8"));
            }
            finally {
                if (labelsStream != null) {
                    labelsStream.close();
                }
            }
        }
        catch (Exception e) {
            try (InputStream labelsStream2 = Labels.class.getClassLoader().getResourceAsStream("messages_" + locale.getLanguage() + ".properties");){
                Labels.instance.labels = new PropertyResourceBundle(new InputStreamReader(labelsStream2, "UTF-8"));
            }
            catch (Exception e2) {
                Labels.instance.labels = Labels.instance.labelsFallback;
            }
        }
    }

    public String get(String key) {
        try {
            return this.labels.getString(key);
        }
        catch (MissingResourceException e) {
            String text = this.labelsFallback.getString(key);
            if (!key.startsWith("language.")) {
                LOG.warning("Used fallback label for " + key);
            }
            return text;
        }
    }

    public static String getLabel(String key) {
        return Labels.getInstance().get(key);
    }

    static {
        Labels.initialize(Locale.getDefault());
    }
}

