/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.fetchers.Fetcher;

public class ScanningResult {
    private InetAddress address;
    private Object[] values;
    private ResultType type;
    ScanningResultList resultList;

    public ScanningResult(InetAddress address, int numberOfFetchers) {
        this.address = address;
        this.values = new Object[numberOfFetchers];
        this.values[0] = address.getHostAddress();
        this.type = ResultType.UNKNOWN;
    }

    public void reset() {
        this.values = new Object[this.values.length];
        this.values[0] = this.address.getHostAddress();
        this.type = ResultType.UNKNOWN;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public boolean isReady() {
        return this.type != ResultType.UNKNOWN;
    }

    public List<Object> getValues() {
        return Arrays.asList(this.values);
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public void setType(ResultType type) {
        this.type = type;
    }

    public ResultType getType() {
        return this.type;
    }

    public void setValue(int fetcherIndex, Object value) {
        this.values[fetcherIndex] = value;
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder details = new StringBuilder(1024);
        Iterator<Object> iterator = this.getValues().iterator();
        List<Fetcher> fetchers = this.resultList.getFetchers();
        int i = 0;
        while (iterator.hasNext()) {
            String fetcherName = fetchers.get(i).getName();
            details.append(fetcherName).append(":\t");
            Object value = iterator.next();
            details.append(value != null ? value : "");
            details.append(newLine);
            ++i;
        }
        return details.toString();
    }

    public static enum ResultType {
        UNKNOWN,
        DEAD,
        ALIVE,
        WITH_PORTS;


        public boolean matches(ResultType that) {
            if (this.ordinal() <= DEAD.ordinal()) {
                return that.ordinal() <= DEAD.ordinal();
            }
            return this.ordinal() <= that.ordinal();
        }
    }
}

