/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultComparator;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherRegistry;

public class ScanningResultList
implements Iterable<ScanningResult> {
    private FetcherRegistry fetcherRegistry;
    private List<Fetcher> selectedFetchers;
    private List<ScanningResult> resultList = new ArrayList<ScanningResult>(1024);
    private Map<InetAddress, Integer> resultIndexes = new HashMap<InetAddress, Integer>(1024);
    private String feederInfo;
    private String feederName;
    ScanInfo info;
    private ScanningResultComparator resultsComparator = new ScanningResultComparator();

    public ScanningResultList(FetcherRegistry fetcherRegistry) {
        this.fetcherRegistry = fetcherRegistry;
    }

    public ScanningResultList(FetcherRegistry fetcherRegistry, StateMachine stateMachine) {
        this(fetcherRegistry);
        stateMachine.addTransitionListener(new StopScanningListener());
    }

    public List<Fetcher> getFetchers() {
        return this.selectedFetchers;
    }

    public boolean areResultsAvailable() {
        return !this.resultList.isEmpty();
    }

    public boolean isInfoAvailable() {
        return this.info != null;
    }

    public String getFeederInfo() {
        return this.feederInfo;
    }

    public String getFeederName() {
        return this.feederName;
    }

    public synchronized ScanningResult createResult(InetAddress address) {
        ++this.info.numScanned;
        Integer index = this.resultIndexes.get(address);
        if (index == null) {
            return new ScanningResult(address, this.fetcherRegistry.getSelectedFetchers().size());
        }
        return this.resultList.get(index);
    }

    public synchronized void registerAtIndex(int index, ScanningResult result) {
        if (this.resultIndexes.put(result.getAddress(), index) != null) {
            throw new IllegalStateException(result.getAddress() + " is already registered in the list");
        }
        result.resultList = this;
        this.resultList.add(index, result);
        if (result.isReady()) {
            this.updateStatistics(result);
        }
    }

    public synchronized boolean isRegistered(ScanningResult result) {
        return this.resultIndexes.containsKey(result.getAddress());
    }

    public synchronized int update(ScanningResult result) {
        if (result.isReady()) {
            this.updateStatistics(result);
        }
        return this.resultIndexes.get(result.getAddress());
    }

    public synchronized void clear() {
        this.resultList.clear();
        this.resultIndexes.clear();
        this.selectedFetchers = null;
    }

    public synchronized void initNewScan(Feeder feeder) {
        this.selectedFetchers = new ArrayList<Fetcher>(this.fetcherRegistry.getSelectedFetchers());
        this.feederInfo = feeder.getInfo();
        this.feederName = feeder.getName();
        this.info = new ScanInfo();
    }

    public ScanInfo getScanInfo() {
        return this.info;
    }

    @Override
    public synchronized Iterator<ScanningResult> iterator() {
        return this.resultList.iterator();
    }

    public synchronized ScanningResult getResult(int index) {
        return this.resultList.get(index);
    }

    public synchronized void remove(int[] indices) {
        ArrayList<ScanningResult> newList = new ArrayList<ScanningResult>(1024);
        HashMap<InetAddress, Integer> newMap = new HashMap<InetAddress, Integer>(1024);
        for (int i = 0; i < this.resultList.size(); ++i) {
            if (Arrays.binarySearch(indices, i) >= 0) continue;
            newList.add(this.resultList.get(i));
            newMap.put(this.resultList.get(i).getAddress(), newList.size() - 1);
        }
        this.resultList = newList;
        this.resultIndexes = newMap;
    }

    public synchronized void sort(int columnIndex, boolean ascending) {
        this.resultsComparator.byIndex(columnIndex, ascending);
        Collections.sort(this.resultList, this.resultsComparator);
        this.resultIndexes = new HashMap<InetAddress, Integer>(1024);
        for (int i = 0; i < this.resultList.size(); ++i) {
            this.resultIndexes.put(this.resultList.get(i).getAddress(), i);
        }
    }

    public int findText(String text, int startIndex) {
        text = text.toLowerCase();
        for (int i = startIndex; i < this.resultList.size(); ++i) {
            ScanningResult scanningResult = this.getResult(i);
            for (Object value : scanningResult.getValues()) {
                if (value == null || !value.toString().toLowerCase().contains(text)) continue;
                return i;
            }
        }
        return -1;
    }

    private void updateStatistics(ScanningResult result) {
        if (this.info == null) {
            return;
        }
        if (result.getType() == ScanningResult.ResultType.ALIVE) {
            ++this.info.numAlive;
        } else if (result.getType() == ScanningResult.ResultType.WITH_PORTS) {
            ++this.info.numAlive;
            ++this.info.numWithPorts;
        }
    }

    public int getFetcherIndex(String fetcherId) {
        int index = 0;
        for (Fetcher fetcher : this.getFetchers()) {
            if (fetcherId.equals(fetcher.getId())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    class StopScanningListener
    implements StateTransitionListener {
        StopScanningListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transitionTo(ScanningState state, StateMachine.Transition transition) {
            ScanningResultList scanningResultList = ScanningResultList.this;
            synchronized (scanningResultList) {
                if (transition == StateMachine.Transition.COMPLETE && state == ScanningState.IDLE) {
                    ScanningResultList.this.info.endTime = System.currentTimeMillis();
                    ScanningResultList.this.info.scanFinished = true;
                } else if (state == ScanningState.KILLING) {
                    ScanningResultList.this.info.scanAborted = true;
                }
            }
        }
    }

    public static class ScanInfo {
        protected boolean scanFinished;
        protected boolean scanAborted;
        protected long startTime = System.currentTimeMillis();
        protected long endTime;
        protected int numScanned;
        protected int numAlive;
        protected int numWithPorts;

        public long getScanTime() {
            long endTime = this.endTime;
            if (endTime == 0L) {
                endTime = System.currentTimeMillis();
            }
            return endTime - this.startTime;
        }

        public int getHostCount() {
            return this.numScanned;
        }

        public int getAliveCount() {
            return this.numAlive;
        }

        public int getWithPortsCount() {
            return this.numWithPorts;
        }

        public boolean isCompletedNormally() {
            return this.scanFinished && !this.scanAborted;
        }
    }
}

