/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.azib.ipscan.config.Config;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.net.PingResult;

public class ScanningSubject {
    ScannerConfig config;
    private InetAddress address;
    private List<Integer> requestedPorts;
    private Map<String, Object> parameters;
    private ScanningResult.ResultType resultType = ScanningResult.ResultType.UNKNOWN;
    private boolean isAborted = false;
    int adaptedPortTimeout = -1;

    public ScanningSubject(InetAddress address) {
        this.address = address;
        this.parameters = new HashMap<String, Object>();
        this.config = Config.getConfig().forScanner();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public boolean isIPv6() {
        return this.address instanceof Inet6Address;
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public ScanningResult.ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ScanningResult.ResultType resultType) {
        this.resultType = resultType;
    }

    public boolean isAddressAborted() {
        return this.isAborted;
    }

    public void abortAddressScanning() {
        this.isAborted = true;
    }

    public boolean isAnyPortRequested() {
        return this.requestedPorts != null;
    }

    public Iterator<Integer> requestedPortsIterator() {
        return this.requestedPorts == null ? null : this.requestedPorts.iterator();
    }

    public void addRequestedPort(Integer requestedPort) {
        if (this.requestedPorts == null) {
            this.requestedPorts = new ArrayList<Integer>();
        }
        this.requestedPorts.add(requestedPort);
    }

    public int getAdaptedPortTimeout() {
        if (this.adaptedPortTimeout > 0) {
            return this.adaptedPortTimeout;
        }
        PingResult pingResult = (PingResult)this.getParameter("pinger");
        if (pingResult != null && this.config.adaptPortTimeout && pingResult.isTimeoutAdaptationAllowed()) {
            this.adaptedPortTimeout = Math.min(Math.max(pingResult.getLongestTime() * 3, this.config.minPortTimeout), this.config.portTimeout);
            return this.adaptedPortTimeout;
        }
        return this.config.portTimeout;
    }

    public boolean isLocal() {
        return this.address.isSiteLocalAddress();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.address.getHostAddress());
        if (this.requestedPorts != null) {
            sb.append(':');
            for (Integer port : this.requestedPorts) {
                sb.append(port).append(',');
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }
}

