/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.io.IOException;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.core.net.TCPPinger;
import net.azib.ipscan.core.net.UDPPinger;

public class CombinedUnprivilegedPinger
implements Pinger {
    private TCPPinger tcpPinger;
    private UDPPinger udpPinger;

    public CombinedUnprivilegedPinger(int timeout) {
        this.udpPinger = new UDPPinger(timeout);
        this.tcpPinger = new TCPPinger(timeout);
    }

    @Override
    public PingResult ping(ScanningSubject subject, int count) throws IOException {
        int udpCountInitialCount = Math.max(1, count / 2);
        PingResult udpResult = this.udpPinger.ping(subject, udpCountInitialCount);
        if (udpResult.isAlive()) {
            return udpResult.merge(this.udpPinger.ping(subject, count - udpCountInitialCount));
        }
        PingResult tcpResult = this.tcpPinger.ping(subject, count);
        return tcpResult.merge(udpResult);
    }

    @Override
    public void close() {
        this.udpPinger.close();
        this.tcpPinger.close();
    }
}

