/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.util.IOUtils;
import org.savarese.rocksaw.net.RawSocket;
import org.savarese.vserv.tcpip.ICMPEchoPacket;
import org.savarese.vserv.tcpip.OctetConverter;

public class ICMPSharedPinger
implements Pinger {
    private static final Logger LOG = LoggerFactory.getLogger();
    private final RawSocket sendingSocket;
    private final RawSocket receivingSocket;
    private Map<InetAddress, PingResult> results = new ConcurrentHashMap<InetAddress, PingResult>();
    private Thread receiverThread;
    private int timeout;
    private int timeOffsetInPacket;

    public ICMPSharedPinger(int timeout) throws IOException {
        this.sendingSocket = new RawSocket();
        this.sendingSocket.open(2, 1);
        this.receivingSocket = new RawSocket();
        this.receivingSocket.open(2, 1);
        this.timeout = timeout;
        try {
            this.sendingSocket.setSendTimeout(timeout);
            this.receivingSocket.setReceiveTimeout(timeout);
        }
        catch (SocketException se) {
            this.sendingSocket.setUseSelectTimeout(true);
            this.receivingSocket.setUseSelectTimeout(true);
            this.sendingSocket.setSendTimeout(timeout);
            this.receivingSocket.setReceiveTimeout(timeout);
        }
        this.receiverThread = new PacketReceiverThread();
        this.receiverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RawSocket rawSocket = this.sendingSocket;
        synchronized (rawSocket) {
            this.sendingSocket.close();
        }
        this.receiverThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PingResult ping(ScanningSubject subject, int count) throws IOException {
        InetAddress address = subject.getAddress();
        PingResult result = new PingResult(address, count);
        this.results.put(address, result);
        ICMPEchoPacket packet = new ICMPEchoPacket(1);
        byte[] data = new byte[84];
        packet.setData(data);
        packet.setIPHeaderLength(5);
        packet.setICMPDataByteLength(56);
        packet.setType(8);
        packet.setCode(0);
        packet.setIdentifier(this.hashCode() & 0xFFFF);
        try {
            for (int i = 1; i <= count && !Thread.currentThread().isInterrupted(); ++i) {
                packet.setSequenceNumber(i);
                int offset = packet.getIPHeaderByteLength();
                this.timeOffsetInPacket = offset + packet.getICMPHeaderByteLength();
                int length = packet.getICMPPacketByteLength();
                OctetConverter.longToOctets(System.currentTimeMillis(), data, this.timeOffsetInPacket);
                packet.computeICMPChecksum();
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Pinging " + i + result.address);
                }
                RawSocket rawSocket = this.sendingSocket;
                synchronized (rawSocket) {
                    this.sendingSocket.write(result.address, data, offset, length);
                }
                try {
                    Thread.sleep(15L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            for (int totalTimeout = this.timeout * count; totalTimeout > 0 && result.getReplyCount() < count; totalTimeout -= this.timeout) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Waiting for response " + address + ": " + totalTimeout);
                }
                PingResult pingResult = result;
                synchronized (pingResult) {
                    try {
                        result.wait(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            PingResult pingResult = result;
            return pingResult;
        }
        finally {
            this.results.remove(address);
        }
    }

    private class PacketReceiverThread
    extends Thread {
        public PacketReceiverThread() {
            super("Ping packet receiver");
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ICMPEchoPacket packet = new ICMPEchoPacket(1);
            byte[] data = new byte[84];
            packet.setData(data);
            packet.setIPHeaderLength(5);
            packet.setICMPDataByteLength(56);
            InetAddress tmpAddress = null;
            try {
                tmpAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                LOG.log(Level.SEVERE, null, e);
            }
            try {
                ICMPSharedPinger.this.receivingSocket.write(tmpAddress, data);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Sending of test packet failed", e);
            }
            do {
                try {
                    ICMPSharedPinger.this.receivingSocket.read(tmpAddress, data);
                    if (packet.getType() == 0 && packet.getIdentifier() == (ICMPSharedPinger.this.hashCode() & 0xFFFF) && packet.getSequenceNumber() > 0) {
                        long endTime = System.currentTimeMillis();
                        PingResult result = (PingResult)ICMPSharedPinger.this.results.get(packet.getSourceAsInetAddress());
                        if (result == null) {
                            LOG.warning("ICMP packet received from an unknown address: " + packet.getSourceAsInetAddress());
                            continue;
                        }
                        long startTime = OctetConverter.octetsToLong(data, ICMPSharedPinger.this.timeOffsetInPacket);
                        long time = endTime - startTime;
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Received " + packet.getSequenceNumber() + packet.getSourceAsInetAddress() + ": " + time);
                        }
                        result.addReply(time);
                        result.setTTL(packet.getTTL() & 0xFF);
                        PingResult pingResult = result;
                        synchronized (pingResult) {
                            result.notifyAll();
                            continue;
                        }
                    }
                    if (packet.getType() == 3) continue;
                }
                catch (InterruptedIOException e) {
                    LOG.finer("Receive timeout");
                }
                catch (UnknownHostException e) {
                    LOG.log(Level.WARNING, "Cannot retrieve the source address of an ICMP packet", e);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Unable to read from the socket", e);
                }
            } while (!PacketReceiverThread.interrupted());
            IOUtils.closeQuietly(ICMPSharedPinger.this.receivingSocket);
            LOG.fine("Terminated");
        }
    }
}

