/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.CombinedUnprivilegedPinger;
import net.azib.ipscan.core.net.ICMPSharedPinger;
import net.azib.ipscan.core.net.JavaPinger;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.core.net.TCPPinger;
import net.azib.ipscan.core.net.UDPPinger;
import net.azib.ipscan.core.net.WindowsPinger;
import net.azib.ipscan.fetchers.FetcherException;

public class PingerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger();
    private ScannerConfig scannerConfig;
    Map<String, Class<? extends Pinger>> pingers;

    public PingerRegistry(ScannerConfig scannerConfig) {
        this.scannerConfig = scannerConfig;
        this.pingers = new LinkedHashMap<String, Class<? extends Pinger>>();
        if (Platform.WINDOWS) {
            this.pingers.put("pinger.windows", WindowsPinger.class);
        }
        if (Platform.LINUX && Platform.ARCH_64) {
            this.pingers.put("pinger.icmp", ICMPSharedPinger.class);
        }
        this.pingers.put("pinger.udp", UDPPinger.class);
        this.pingers.put("pinger.tcp", TCPPinger.class);
        this.pingers.put("pinger.combined", CombinedUnprivilegedPinger.class);
        this.pingers.put("pinger.java", JavaPinger.class);
    }

    public String[] getRegisteredNames() {
        return this.pingers.keySet().toArray(new String[this.pingers.size()]);
    }

    public Pinger createPinger() throws FetcherException {
        return this.createPinger(this.scannerConfig.selectedPinger, this.scannerConfig.pingTimeout);
    }

    Pinger createPinger(String pingerName, int timeout) throws FetcherException {
        Class<? extends Pinger> pingerClass = this.pingers.get(pingerName);
        try {
            Constructor<? extends Pinger> constructor = pingerClass.getConstructor(Integer.TYPE);
            return constructor.newInstance(timeout);
        }
        catch (Exception e) {
            Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
            String message = "Unable to create pinger: " + pingerName;
            LOG.log(Level.SEVERE, message, t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new FetcherException("pingerCreateFailure");
        }
    }

    public boolean checkSelectedPinger() {
        if (this.scannerConfig.selectedPinger.startsWith("pinger.icmp")) {
            try {
                Pinger icmpPinger = this.createPinger(this.scannerConfig.selectedPinger, 250);
                icmpPinger.ping(new ScanningSubject(InetAddress.getLocalHost()), 1);
            }
            catch (Throwable e) {
                LOG.info("ICMP pinger failed: " + e);
                this.scannerConfig.selectedPinger = Platform.WINDOWS ? "pinger.windows" : "pinger.combined";
                return false;
            }
        }
        return true;
    }
}

