/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.util.IOUtils;

public class UDPPinger
implements Pinger {
    private static final Logger LOG = LoggerFactory.getLogger();
    private int timeout;

    public UDPPinger(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PingResult ping(ScanningSubject subject, int count) throws IOException {
        PingResult result = new PingResult(subject.getAddress(), count);
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(this.timeout);
            socket.connect(subject.getAddress(), 37381);
            for (int i = 0; i < count && !Thread.currentThread().isInterrupted(); ++i) {
                byte[] payload = new byte[8];
                long startTime = System.currentTimeMillis();
                ByteBuffer.wrap(payload).putLong(startTime);
                DatagramPacket packet = new DatagramPacket(payload, payload.length);
                try {
                    socket.send(packet);
                    socket.receive(packet);
                    continue;
                }
                catch (PortUnreachableException e) {
                    result.addReply(System.currentTimeMillis() - startTime);
                    continue;
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                catch (NoRouteToHostException e) {
                    break;
                }
                catch (SocketException e) {
                    if (!e.getMessage().contains("route to host")) continue;
                    break;
                }
                catch (IOException e) {
                    if (e.getMessage().startsWith("Network is unreachable")) break;
                    LOG.log(Level.FINER, subject.toString(), e);
                }
            }
            PingResult pingResult = result;
            return pingResult;
        }
        finally {
            IOUtils.closeQuietly(socket);
        }
    }

    @Override
    public void close() {
    }
}

