/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.core.net.WinIpHlp;
import net.azib.ipscan.core.net.WinIpHlpDll;

public class WindowsPinger
implements Pinger {
    private int timeout;
    private WinIpHlpDll.Ip6SockAddrByRef anyIp6SourceAddr = new WinIpHlpDll.Ip6SockAddrByRef();

    public WindowsPinger(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public PingResult ping(ScanningSubject subject, int count) throws IOException {
        if (subject.isIPv6()) {
            return this.ping6(subject, count);
        }
        return this.ping4(subject, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PingResult ping4(ScanningSubject subject, int count) throws IOException {
        Pointer handle = WinIpHlpDll.dll.IcmpCreateFile();
        if (handle == null) {
            throw new IOException("Unable to create Windows native ICMP handle");
        }
        int sendDataSize = 32;
        int replyDataSize = sendDataSize + new WinIpHlpDll.IcmpEchoReply().size() + 10;
        Memory sendData = new Memory((long)sendDataSize);
        sendData.clear((long)sendDataSize);
        Memory replyData = new Memory((long)replyDataSize);
        PingResult result = new PingResult(subject.getAddress(), count);
        try {
            WinIpHlpDll.IpAddrByVal ipaddr = WinIpHlp.toIpAddr(subject.getAddress());
            for (int i = 1; i <= count && !Thread.currentThread().isInterrupted(); ++i) {
                int numReplies = WinIpHlpDll.dll.IcmpSendEcho(handle, ipaddr, (Pointer)sendData, (short)sendDataSize, null, (Pointer)replyData, replyDataSize, this.timeout);
                WinIpHlpDll.IcmpEchoReply echoReply = new WinIpHlpDll.IcmpEchoReply((Pointer)replyData);
                if (numReplies <= 0 || echoReply.status != 0 || !Arrays.equals(echoReply.address.bytes, ipaddr.bytes)) continue;
                result.addReply(echoReply.roundTripTime);
                result.setTTL(echoReply.options.ttl & 0xFF);
            }
        }
        finally {
            WinIpHlpDll.dll.IcmpCloseHandle(handle);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PingResult ping6(ScanningSubject subject, int count) throws IOException {
        Pointer handle = WinIpHlpDll.dll.Icmp6CreateFile();
        if (handle == null) {
            throw new IOException("Unable to create Windows native ICMP6 handle");
        }
        int sendDataSize = 32;
        int replyDataSize = sendDataSize + new WinIpHlpDll.Icmp6EchoReply().size() + 10;
        Memory sendData = new Memory((long)sendDataSize);
        sendData.clear((long)sendDataSize);
        Memory replyData = new Memory((long)replyDataSize);
        PingResult result = new PingResult(subject.getAddress(), count);
        try {
            WinIpHlpDll.Ip6SockAddrByRef ipaddr = WinIpHlp.toIp6Addr(subject.getAddress());
            for (int i = 1; i <= count && !Thread.currentThread().isInterrupted(); ++i) {
                int numReplies = WinIpHlpDll.dll.Icmp6SendEcho2(handle, null, null, null, this.anyIp6SourceAddr, WinIpHlp.toIp6Addr(subject.getAddress()), (Pointer)sendData, (short)sendDataSize, null, (Pointer)replyData, replyDataSize, this.timeout);
                WinIpHlpDll.Icmp6EchoReply echoReply = new WinIpHlpDll.Icmp6EchoReply((Pointer)replyData);
                if (numReplies <= 0 || echoReply.status != 0 || !Arrays.equals(echoReply.addressBytes, ipaddr.bytes)) continue;
                result.addReply(echoReply.roundTripTime);
            }
        }
        finally {
            WinIpHlpDll.dll.IcmpCloseHandle(handle);
        }
        return result;
    }

    @Override
    public void close() {
    }

    public static void main(String[] args) throws IOException {
        PingResult ping = new WindowsPinger(5000).ping(new ScanningSubject(InetAddress.getByName("::1")), 1);
        System.out.println(ping.getAverageTime() + "ms");
        System.out.println("TTL " + ping.getTTL());
    }
}

