/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.exporters;

import java.io.IOException;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.PortIterator;
import net.azib.ipscan.core.values.NumericRangeList;
import net.azib.ipscan.exporters.AbstractExporter;
import net.azib.ipscan.exporters.ExporterException;

public class IPListExporter
extends AbstractExporter {
    private int ipFetcherIndex;
    private int portsFetcherIndex;

    @Override
    public String getId() {
        return "exporter.ipList";
    }

    @Override
    public String getFilenameExtension() {
        return "lst";
    }

    @Override
    public void setFetchers(String[] fetcherNames) throws IOException {
        this.ipFetcherIndex = IPListExporter.findFetcherById("fetcher.ip", fetcherNames);
        this.portsFetcherIndex = IPListExporter.findFetcherById("fetcher.ports", fetcherNames);
    }

    static int findFetcherById(String fetcherId, String[] fetcherNames) {
        String fetcherName = Labels.getLabel(fetcherId);
        for (int i = 0; i < fetcherNames.length; ++i) {
            if (!fetcherName.equals(fetcherNames[i])) continue;
            return i;
        }
        throw new ExporterException("fetcher.notFound");
    }

    @Override
    public void nextAddressResults(Object[] results) throws IOException {
        String address = results[this.ipFetcherIndex].toString();
        Object ports = results[this.portsFetcherIndex];
        if (ports instanceof NumericRangeList) {
            PortIterator i = new PortIterator(ports.toString());
            while (i.hasNext()) {
                this.output.println(address + ':' + i.next());
            }
        }
    }
}

