/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.feeders;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.feeders.AbstractFeeder;
import net.azib.ipscan.feeders.FeederException;
import net.azib.ipscan.util.InetAddressUtils;

public class RandomFeeder
extends AbstractFeeder {
    SecureRandom random = new SecureRandom();
    byte[] prototypeBytes;
    byte[] maskBytes;
    byte[] currentBytes;
    int addressCount;
    int currentNumber;

    @Override
    public String getId() {
        return "feeder.random";
    }

    public RandomFeeder() {
    }

    public RandomFeeder(String prototypeIP, String mask, int count) {
        try {
            this.prototypeBytes = InetAddress.getByName(prototypeIP).getAddress();
        }
        catch (UnknownHostException e) {
            throw new FeederException("malformedIP");
        }
        try {
            this.maskBytes = InetAddressUtils.parseNetmask(mask).getAddress();
        }
        catch (UnknownHostException e) {
            throw new FeederException("invalidNetmask");
        }
        if (count <= 0) {
            throw new FeederException("random.invalidCount");
        }
        this.currentNumber = 0;
        this.addressCount = count;
        this.currentBytes = new byte[this.prototypeBytes.length];
    }

    @Override
    public int percentageComplete() {
        return Math.round((float)this.currentNumber * 100.0f / (float)this.addressCount);
    }

    @Override
    public boolean hasNext() {
        return this.currentNumber < this.addressCount;
    }

    @Override
    public ScanningSubject next() {
        ++this.currentNumber;
        this.random.nextBytes(this.currentBytes);
        try {
            InetAddressUtils.maskPrototypeAddressBytes(this.currentBytes, this.maskBytes, this.prototypeBytes);
            return new ScanningSubject(InetAddress.getByAddress(this.currentBytes));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInfo() {
        try {
            return this.addressCount + ": " + InetAddress.getByAddress(this.prototypeBytes).getHostAddress() + " / " + InetAddress.getByAddress(this.maskBytes).getHostAddress();
        }
        catch (UnknownHostException e) {
            assert (false) : e;
            return null;
        }
    }
}

