/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.feeders;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.feeders.AbstractFeeder;
import net.azib.ipscan.feeders.FeederException;
import net.azib.ipscan.util.InetAddressUtils;
import org.savarese.vserv.tcpip.OctetConverter;

public class RangeFeeder
extends AbstractFeeder {
    private InetAddress startIP;
    private InetAddress endIP;
    private InetAddress originalEndIP;
    private InetAddress currentIP;
    boolean isReverse;
    double percentageComplete;
    double percentageIncrement;

    @Override
    public String getId() {
        return "feeder.range";
    }

    public RangeFeeder() {
    }

    public RangeFeeder(String startIP, String endIP) {
        try {
            this.startIP = this.currentIP = InetAddress.getByName(startIP);
            this.endIP = this.originalEndIP = InetAddress.getByName(endIP);
            this.isReverse = false;
        }
        catch (UnknownHostException e) {
            throw new FeederException("malformedIP");
        }
        if (InetAddressUtils.greaterThan(this.startIP, this.endIP)) {
            this.isReverse = true;
            this.endIP = InetAddressUtils.decrement(InetAddressUtils.decrement(this.endIP));
        }
        this.initPercentageIncrement();
        this.endIP = InetAddressUtils.increment(this.endIP);
    }

    private void initPercentageIncrement() {
        long rawEndIP = OctetConverter.octetsToInt(this.endIP.getAddress());
        long rawStartIP = OctetConverter.octetsToInt(this.startIP.getAddress());
        rawEndIP = rawEndIP >= 0L ? rawEndIP : rawEndIP + Integer.MAX_VALUE;
        rawStartIP = rawStartIP >= 0L ? rawStartIP : rawStartIP + Integer.MAX_VALUE;
        this.percentageIncrement = Math.abs(100.0 / (double)(rawEndIP - rawStartIP + 1L));
        this.percentageComplete = 0.0;
    }

    @Override
    public boolean hasNext() {
        return !this.currentIP.equals(this.endIP);
    }

    @Override
    public ScanningSubject next() {
        this.percentageComplete += this.percentageIncrement;
        InetAddress prevIP = this.currentIP;
        this.currentIP = this.isReverse ? InetAddressUtils.decrement(prevIP) : InetAddressUtils.increment(prevIP);
        return new ScanningSubject(prevIP);
    }

    @Override
    public int percentageComplete() {
        return (int)Math.round(this.percentageComplete);
    }

    @Override
    public String getInfo() {
        return this.startIP.getHostAddress() + " - " + this.originalEndIP.getHostAddress();
    }
}

