/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.feeders;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.feeders.AbstractFeeder;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.feeders.FeederException;

public class RescanFeeder
extends AbstractFeeder {
    private Feeder originalFeeder;
    private List<InetAddress> addresses;
    int current;

    public RescanFeeder(Feeder oldFeeder, String ... ips) {
        this.originalFeeder = oldFeeder;
        this.initAddresses(ips);
    }

    @Override
    public String getId() {
        return this.originalFeeder.getId();
    }

    @Override
    public String getName() {
        return Labels.getLabel("feeder.rescan.of") + this.originalFeeder.getName();
    }

    private int initAddresses(String ... ips) {
        if (ips.length == 0) {
            throw new IllegalArgumentException("no IP addresses specified");
        }
        try {
            this.addresses = new ArrayList<InetAddress>(ips.length);
            for (String s : ips) {
                this.addresses.add(InetAddress.getByName(s));
            }
        }
        catch (UnknownHostException e) {
            throw new FeederException("malformedIP");
        }
        return ips.length;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.addresses.size();
    }

    @Override
    public ScanningSubject next() {
        return new ScanningSubject(this.addresses.get(this.current++));
    }

    @Override
    public int percentageComplete() {
        return this.current * 100 / this.addresses.size();
    }

    @Override
    public String getInfo() {
        return this.originalFeeder.getInfo();
    }
}

