/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.AbstractFetcher;

public abstract class MACFetcher
extends AbstractFetcher {
    static final Pattern macAddressPattern = Pattern.compile("([a-fA-F0-9]{1,2}[-:]){5}[a-fA-F0-9]{1,2}");
    static final Pattern leadingZeroesPattern = Pattern.compile("(?<=^|-|:)([A-F0-9])(?=-|:|$)");

    @Override
    public String getId() {
        return "fetcher.mac";
    }

    @Override
    public final String scan(ScanningSubject subject) {
        String mac = (String)subject.getParameter("fetcher.mac");
        if (mac == null) {
            mac = this.resolveMAC(subject.getAddress());
        }
        subject.setParameter("fetcher.mac", mac);
        return mac;
    }

    protected abstract String resolveMAC(InetAddress var1);

    static String bytesToMAC(byte[] bytes) {
        StringBuilder mac = new StringBuilder();
        for (byte b : bytes) {
            mac.append(String.format("%02X", b)).append(":");
        }
        if (mac.length() > 0) {
            mac.deleteCharAt(mac.length() - 1);
        }
        return mac.toString();
    }

    static String extractMAC(String line) {
        Matcher m = macAddressPattern.matcher(line);
        return m.find() ? MACFetcher.addLeadingZeroes(m.group().toUpperCase()) : null;
    }

    private static String addLeadingZeroes(String mac) {
        return leadingZeroesPattern.matcher(mac).replaceAll("0$1");
    }
}

