/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.core.net.PingerRegistry;
import net.azib.ipscan.core.values.IntegerWithUnit;
import net.azib.ipscan.fetchers.AbstractFetcher;
import net.azib.ipscan.fetchers.FetcherException;
import net.azib.ipscan.fetchers.FetcherPrefs;
import net.azib.ipscan.gui.fetchers.PingFetcherPrefs;

public class PingFetcher
extends AbstractFetcher {
    private static final Logger LOG = LoggerFactory.getLogger();
    private ScannerConfig config;
    private static volatile Pinger pinger;
    private static volatile AtomicInteger pingerUsers;
    private PingerRegistry pingerRegistry;

    public PingFetcher(PingerRegistry pingerRegistry, ScannerConfig scannerConfig) {
        this.pingerRegistry = pingerRegistry;
        this.config = scannerConfig;
    }

    @Override
    public String getId() {
        return "fetcher.ping";
    }

    @Override
    public Class<? extends FetcherPrefs> getPreferencesClass() {
        return PingFetcherPrefs.class;
    }

    protected PingResult executePing(ScanningSubject subject) {
        PingResult result;
        if (subject.hasParameter("pinger")) {
            return (PingResult)subject.getParameter("pinger");
        }
        try {
            result = pinger.ping(subject, this.config.pingCount);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Pinging failed", e);
            result = new PingResult(subject.getAddress(), 0);
        }
        subject.setParameter("pinger", result);
        return result;
    }

    @Override
    public Object scan(ScanningSubject subject) {
        PingResult result = this.executePing(subject);
        subject.setResultType(result.isAlive() ? ScanningResult.ResultType.ALIVE : ScanningResult.ResultType.DEAD);
        if (!result.isAlive() && !this.config.scanDeadHosts) {
            subject.abortAddressScanning();
        }
        return result.isAlive() ? new IntegerWithUnit(result.getAverageTime(), "ms") : null;
    }

    @Override
    public void init() {
        if (pinger == null) {
            pinger = this.pingerRegistry.createPinger();
            pingerUsers.set(1);
        } else {
            pingerUsers.incrementAndGet();
        }
    }

    @Override
    public void cleanup() {
        try {
            if (pingerUsers.decrementAndGet() <= 0 && pinger != null) {
                pinger.close();
                pinger = null;
            }
        }
        catch (IOException e) {
            pinger = null;
            throw new FetcherException(e);
        }
    }

    static {
        pingerUsers = new AtomicInteger();
    }
}

