/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.PortIterator;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.values.NotScanned;
import net.azib.ipscan.core.values.NumericRangeList;
import net.azib.ipscan.fetchers.AbstractFetcher;
import net.azib.ipscan.fetchers.FetcherPrefs;
import net.azib.ipscan.gui.fetchers.PortsFetcherPrefs;
import net.azib.ipscan.util.SequenceIterator;
import net.azib.ipscan.util.ThreadResourceBinder;

public class PortsFetcher
extends AbstractFetcher {
    private ScannerConfig config;
    private ThreadResourceBinder<Socket> sockets = new ThreadResourceBinder();
    private PortIterator portIteratorPrototype;
    protected boolean displayAsRanges = true;

    public PortsFetcher(ScannerConfig scannerConfig) {
        this.config = scannerConfig;
    }

    @Override
    public String getId() {
        return "fetcher.ports";
    }

    @Override
    public String getFullName() {
        int numPorts = new PortIterator(this.config.portString).size();
        return this.getName() + " [" + numPorts + (this.config.useRequestedPorts ? "+" : "") + "]";
    }

    @Override
    public Class<? extends FetcherPrefs> getPreferencesClass() {
        return PortsFetcherPrefs.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scanPorts(ScanningSubject subject) {
        SortedSet<Integer> openPorts = this.getOpenPorts(subject);
        if (openPorts == null) {
            openPorts = new TreeSet<Integer>();
            TreeSet<Integer> filteredPorts = new TreeSet<Integer>();
            subject.setParameter("openPorts", openPorts);
            subject.setParameter("filteredPorts", filteredPorts);
            int portTimeout = subject.getAdaptedPortTimeout();
            Iterator<Integer> portsIterator = this.portIteratorPrototype.copy();
            if (this.config.useRequestedPorts && subject.isAnyPortRequested()) {
                portsIterator = new SequenceIterator(portsIterator, subject.requestedPortsIterator());
            }
            if (!portsIterator.hasNext()) {
                return false;
            }
            while (portsIterator.hasNext() && !Thread.currentThread().isInterrupted()) {
                Socket socket = this.sockets.bind(new Socket());
                int port = portsIterator.next();
                try {
                    socket.setReuseAddress(true);
                    socket.setReceiveBufferSize(32);
                    socket.connect(new InetSocketAddress(subject.getAddress(), port), portTimeout);
                    socket.setSoLinger(true, 0);
                    socket.setSendBufferSize(16);
                    socket.setTcpNoDelay(true);
                    if (!socket.isConnected()) continue;
                    openPorts.add(port);
                }
                catch (SocketTimeoutException e) {
                    filteredPorts.add(port);
                }
                catch (IOException e) {
                    assert (e instanceof ConnectException) : e;
                }
                finally {
                    this.sockets.closeAndUnbind(socket);
                }
            }
        }
        return true;
    }

    protected SortedSet<Integer> getFilteredPorts(ScanningSubject subject) {
        return (SortedSet)subject.getParameter("filteredPorts");
    }

    protected SortedSet<Integer> getOpenPorts(ScanningSubject subject) {
        return (SortedSet)subject.getParameter("openPorts");
    }

    @Override
    public Object scan(ScanningSubject subject) {
        boolean portsScanned = this.scanPorts(subject);
        if (!portsScanned) {
            return NotScanned.VALUE;
        }
        SortedSet<Integer> openPorts = this.getOpenPorts(subject);
        if (!openPorts.isEmpty()) {
            subject.setResultType(ScanningResult.ResultType.WITH_PORTS);
            return new NumericRangeList(openPorts, this.displayAsRanges);
        }
        return null;
    }

    @Override
    public void init() {
        this.portIteratorPrototype = new PortIterator(this.config.portString);
    }

    @Override
    public void cleanup() {
        this.sockets.close();
    }
}

