/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.fetchers.MACFetcher;
import net.azib.ipscan.util.IOUtils;

public class UnixMACFetcher
extends MACFetcher {
    private String arp = Platform.LINUX ? "arp -an " : "arp -n ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String resolveMAC(InetAddress address) {
        String ip = address.getHostAddress();
        BufferedReader reader = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec(this.arp + ip);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains(ip)) continue;
                String string = UnixMACFetcher.extractMAC(line);
                IOUtils.closeQuietly(reader);
                return string;
            }
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            while (ifs.hasMoreElements()) {
                NetworkInterface netif = ifs.nextElement();
                if (!netif.isUp() || netif.isVirtual() || netif.isLoopback()) continue;
                Enumeration<InetAddress> addrs = netif.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addr.equals(address)) continue;
                    String string = UnixMACFetcher.bytesToMAC(netif.getHardwareAddress());
                    IOUtils.closeQuietly(reader);
                    return string;
                }
            }
            String string = null;
            IOUtils.closeQuietly(reader);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }
}

