/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.CommentsConfig;
import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DetailsWindow
extends AbstractModalDialog {
    private GUIConfig guiConfig;
    private CommentsConfig commentsConfig;
    private ResultTable resultTable;
    private ScanningResultList scanningResults;
    int resultIndex;
    private Text commentsText;

    public DetailsWindow(GUIConfig guiConfig, CommentsConfig commentsConfig, ResultTable resultTable, ScanningResultList scanningResults) {
        this.guiConfig = guiConfig;
        this.commentsConfig = commentsConfig;
        this.resultTable = resultTable;
        this.scanningResults = scanningResults;
    }

    @Override
    protected int getShellStyle() {
        return 67700;
    }

    @Override
    protected void populateShell() {
        this.shell.setText(Labels.getLabel("title.details"));
        this.shell.setLayout(LayoutHelper.formLayout(3, 3, 3));
        this.shell.setSize(this.guiConfig.getDetailsWindowSize());
        this.resultIndex = this.resultTable.getSelectionIndex();
        ScanningResult result = this.resultTable.getSelectedResult();
        this.commentsText = new Text(this.shell, 2048);
        this.commentsText.pack();
        this.commentsText.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(100), null, new FormAttachment(100)));
        CommentsTextListener commentsTextListener = new CommentsTextListener();
        this.commentsText.addFocusListener(commentsTextListener);
        this.commentsText.addModifyListener(commentsTextListener);
        String comment = this.commentsConfig.getComment(this.scanningResults, this.resultIndex);
        if (comment != null) {
            this.commentsText.setText(comment);
        } else {
            commentsTextListener.focusLost(null);
        }
        Text detailsText = new Text(this.shell, 2634);
        detailsText.setText(result.toString());
        detailsText.setBackground(this.shell.getDisplay().getSystemColor(25));
        detailsText.setTabs(32);
        detailsText.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(100), new FormAttachment(0), new FormAttachment(this.commentsText)));
        TraverseListener traverseListener = new TraverseListener();
        detailsText.addListener(31, traverseListener);
        this.commentsText.addListener(31, traverseListener);
        this.shell.layout();
        detailsText.forceFocus();
        this.shell.addListener(21, event -> this.guiConfig.setDetailsWindowSize(this.shell.getSize()));
    }

    class TraverseListener
    implements Listener {
        TraverseListener() {
        }

        @Override
        public void handleEvent(Event e) {
            if (e.detail == 4) {
                DetailsWindow.this.shell.close();
                DetailsWindow.this.shell.dispose();
            }
        }
    }

    class CommentsTextListener
    implements FocusListener,
    ModifyListener {
        String defaultText = Labels.getLabel("text.comment.edit");

        CommentsTextListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (DetailsWindow.this.commentsText.getText().equals(this.defaultText)) {
                DetailsWindow.this.commentsText.setText("");
                DetailsWindow.this.commentsText.setForeground(DetailsWindow.this.commentsText.getDisplay().getSystemColor(21));
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (DetailsWindow.this.commentsText.getText().length() == 0) {
                DetailsWindow.this.commentsText.setText(this.defaultText);
                DetailsWindow.this.commentsText.setForeground(DetailsWindow.this.commentsText.getDisplay().getSystemColor(18));
            }
        }

        @Override
        public void modifyText(ModifyEvent e) {
            String newComment = DetailsWindow.this.commentsText.getText();
            if (!this.defaultText.equals(newComment)) {
                DetailsWindow.this.commentsConfig.setComment(DetailsWindow.this.scanningResults, DetailsWindow.this.resultIndex, newComment);
                DetailsWindow.this.resultTable.updateResult(DetailsWindow.this.resultIndex, "fetcher.comment", newComment);
            }
        }
    }
}

