/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import java.io.File;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.OpenersConfig;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherRegistry;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditOpenersDialog
extends AbstractModalDialog {
    private final FetcherRegistry fetcherRegistry;
    private final OpenersConfig openersConfig;
    private List openersList;
    private Group editFieldsGroup;
    private Text openerNameText;
    private Text openerStringText;
    private Text workingDirText;
    private Button isInTerminalCheckbox;
    private int currentSelectionIndex;

    public EditOpenersDialog(FetcherRegistry fetcherRegistry, OpenersConfig openersConfig) {
        this.fetcherRegistry = fetcherRegistry;
        this.openersConfig = openersConfig;
    }

    @Override
    protected void populateShell() {
        Display currentDisplay = Display.getCurrent();
        Shell parent = currentDisplay != null ? currentDisplay.getActiveShell() : null;
        this.shell = new Shell(parent, 67680);
        this.shell.setText(Labels.getLabel("title.openers.edit"));
        this.shell.setLayout(LayoutHelper.formLayout(10, 10, 4));
        Label messageLabel = new Label(this.shell, 0);
        messageLabel.setText(Labels.getLabel("text.openers.edit"));
        this.openersList = new List(this.shell, 2562);
        this.editFieldsGroup = new Group(this.shell, 0);
        this.openersList.setLayoutData(LayoutHelper.formData(140, 200, null, null, new FormAttachment(messageLabel, 10), new FormAttachment(this.editFieldsGroup, 0, 1024)));
        for (String name : this.openersConfig) {
            this.openersList.add(name);
        }
        this.openersList.addListener(13, new ItemSelectListener());
        Font iconFont = LayoutHelper.iconFont(this.shell);
        Button upButton = new Button(this.shell, 0);
        upButton.setText(Labels.getLabel("button.up"));
        upButton.setToolTipText(Labels.getLabel("button.up.hint"));
        upButton.setFont(iconFont);
        upButton.addListener(13, new AbstractModalDialog.UpButtonListener(this.openersList){

            @Override
            public void handleEvent(Event event) {
                super.handleEvent(event);
                EditOpenersDialog.this.currentSelectionIndex = EditOpenersDialog.this.openersList.getSelectionIndex();
            }
        });
        Button downButton = new Button(this.shell, 0);
        downButton.setText(Labels.getLabel("button.down"));
        downButton.setToolTipText(Labels.getLabel("button.down.hint"));
        downButton.setFont(iconFont);
        downButton.addListener(13, new AbstractModalDialog.DownButtonListener(this.openersList){

            @Override
            public void handleEvent(Event event) {
                super.handleEvent(event);
                EditOpenersDialog.this.currentSelectionIndex = EditOpenersDialog.this.openersList.getSelectionIndex();
            }
        });
        Button addButton = new Button(this.shell, 0);
        addButton.setText(Labels.getLabel("button.add"));
        addButton.addListener(13, new AddButtonListener());
        Button deleteButton = new Button(this.shell, 0);
        deleteButton.setText(Labels.getLabel("button.delete"));
        deleteButton.addListener(13, new DeleteButtonListener());
        upButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.openersList), null, new FormAttachment(messageLabel, 10), null));
        downButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.openersList), null, new FormAttachment(upButton), null));
        addButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.openersList), new FormAttachment(deleteButton, 0, 131072), new FormAttachment(downButton, 16), null));
        deleteButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.openersList), null, new FormAttachment(addButton), null));
        this.editFieldsGroup.setLayoutData(LayoutHelper.formData(new FormAttachment(deleteButton, 10), null, new FormAttachment(messageLabel, 10), null));
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.justify = true;
        rowLayout.marginTop = 5;
        rowLayout.marginBottom = 20;
        rowLayout.marginWidth = 5;
        this.editFieldsGroup.setLayout(rowLayout);
        Label openerNameLabel = new Label(this.editFieldsGroup, 0);
        openerNameLabel.setText(Labels.getLabel("text.openers.name"));
        openerNameLabel.setSize(-1, 18);
        this.openerNameText = new Text(this.editFieldsGroup, 2048);
        this.openerNameText.setSize(-1, 22);
        this.openerNameText.addListener(2, new OpenerNameChange());
        this.isInTerminalCheckbox = new Button(this.editFieldsGroup, 32);
        this.isInTerminalCheckbox.setText(Labels.getLabel("text.openers.inTerminal"));
        this.isInTerminalCheckbox.setSize(-1, 18);
        Label openerStringLabel = new Label(this.editFieldsGroup, 0);
        openerStringLabel.setText(Labels.getLabel("text.openers.string"));
        openerStringLabel.setSize(-1, 18);
        this.openerStringText = new Text(this.editFieldsGroup, 2048);
        this.openerStringText.setSize(-1, 22);
        Button hintButton = new Button(this.editFieldsGroup, 0);
        hintButton.setText(Labels.getLabel("text.openers.hint"));
        hintButton.addListener(13, new HintButtonListener());
        Label openerDirLabel = new Label(this.editFieldsGroup, 0);
        openerDirLabel.setText(Labels.getLabel("text.openers.directory"));
        openerDirLabel.setSize(-1, 18);
        this.workingDirText = new Text(this.editFieldsGroup, 2048);
        this.workingDirText.setSize(-1, 22);
        this.editFieldsGroup.pack();
        Button okButton = new Button(this.shell, 0);
        okButton.setText(Labels.getLabel("button.OK"));
        Button cancelButton = new Button(this.shell, 0);
        cancelButton.setText(Labels.getLabel("button.cancel"));
        this.positionButtonsInFormLayout(okButton, cancelButton, this.editFieldsGroup);
        this.shell.pack();
        okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                EditOpenersDialog.this.saveOpeners();
                EditOpenersDialog.this.shell.close();
            }
        });
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                EditOpenersDialog.this.shell.close();
            }
        });
        this.openersList.select(0);
        this.loadFieldsForSelection();
    }

    private void saveOpeners() {
        this.saveCurrentFields();
        this.openersConfig.update(this.openersList.getItems());
        this.openersConfig.store();
    }

    private void saveCurrentFields() {
        if (this.currentSelectionIndex < 0) {
            return;
        }
        String openerName = this.openerNameText.getText();
        File workingDir = this.workingDirText.getText().length() > 0 ? new File(this.workingDirText.getText()) : null;
        this.openersConfig.add(openerName, new OpenersConfig.Opener(this.openerStringText.getText(), this.isInTerminalCheckbox.getSelection(), workingDir));
        this.openersList.setItem(this.currentSelectionIndex, openerName);
    }

    private void loadFieldsForSelection() {
        this.currentSelectionIndex = this.openersList.getSelectionIndex();
        if (this.currentSelectionIndex < 0) {
            return;
        }
        String openerName = this.openersList.getItem(this.currentSelectionIndex);
        this.editFieldsGroup.setText(openerName);
        OpenersConfig.Opener opener = this.openersConfig.getOpener(openerName);
        this.openerNameText.setText(openerName);
        this.openerStringText.setText(opener.execString);
        this.workingDirText.setText(opener.workingDir != null ? opener.workingDir.toString() : "");
        this.isInTerminalCheckbox.setSelection(opener.inTerminal);
    }

    class OpenerNameChange
    implements Listener {
        OpenerNameChange() {
        }

        @Override
        public void handleEvent(Event event) {
            if (EditOpenersDialog.this.currentSelectionIndex < 0) {
                return;
            }
            String name = EditOpenersDialog.this.openerNameText.getText();
            EditOpenersDialog.this.editFieldsGroup.setText(name);
            EditOpenersDialog.this.openersList.setItem(EditOpenersDialog.this.currentSelectionIndex, name);
        }
    }

    class ItemSelectListener
    implements Listener {
        ItemSelectListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (EditOpenersDialog.this.openersList.getSelectionCount() == 0) {
                return;
            }
            EditOpenersDialog.this.saveCurrentFields();
            EditOpenersDialog.this.loadFieldsForSelection();
        }
    }

    class AddButtonListener
    implements Listener {
        AddButtonListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EditOpenersDialog.this.saveCurrentFields();
            EditOpenersDialog.this.currentSelectionIndex = EditOpenersDialog.this.openersList.getSelectionIndex();
            if (EditOpenersDialog.this.currentSelectionIndex < 0) {
                EditOpenersDialog.this.currentSelectionIndex = EditOpenersDialog.this.openersList.getItemCount();
            }
            String newName = Labels.getLabel("text.openers.new");
            EditOpenersDialog.this.openersList.add(newName, EditOpenersDialog.this.currentSelectionIndex);
            EditOpenersDialog.this.openersList.setSelection(EditOpenersDialog.this.currentSelectionIndex);
            EditOpenersDialog.this.editFieldsGroup.setText(newName);
            EditOpenersDialog.this.openerNameText.setText(newName);
            EditOpenersDialog.this.openerStringText.setText("${fetcher.ip}");
            EditOpenersDialog.this.workingDirText.setText("");
            EditOpenersDialog.this.isInTerminalCheckbox.setSelection(false);
            EditOpenersDialog.this.openerNameText.forceFocus();
            EditOpenersDialog.this.openerNameText.setSelection(0, newName.length());
        }
    }

    class DeleteButtonListener
    implements Listener {
        DeleteButtonListener() {
        }

        @Override
        public void handleEvent(Event event) {
            int oldIndex = EditOpenersDialog.this.openersList.getSelectionIndex();
            EditOpenersDialog.this.openersList.remove(EditOpenersDialog.this.openersList.getSelectionIndices());
            if (oldIndex >= EditOpenersDialog.this.openersList.getItemCount()) {
                oldIndex = EditOpenersDialog.this.openersList.getItemCount() - 1;
            }
            EditOpenersDialog.this.openersList.setSelection(oldIndex);
            EditOpenersDialog.this.loadFieldsForSelection();
        }
    }

    class HintButtonListener
    implements Listener {
        HintButtonListener() {
        }

        @Override
        public void handleEvent(Event event) {
            StringBuilder message = new StringBuilder(Labels.getLabel("text.openers.hintText"));
            for (Fetcher fetcher : EditOpenersDialog.this.fetcherRegistry.getSelectedFetchers()) {
                message.append("${").append(fetcher.getId()).append("}   - ").append(fetcher.getName()).append('\n');
            }
            MessageBox mb = new MessageBox(EditOpenersDialog.this.shell, 34);
            mb.setText(Labels.getLabel("title.openers.edit"));
            mb.setMessage(message.toString());
            mb.open();
        }
    }
}

