/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.actions.CommandsMenuActions;
import net.azib.ipscan.gui.actions.ToolsActions;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class StatusBar {
    private Composite composite;
    private Label statusText;
    private Label displayMethodText;
    private Label threadsText;
    private boolean maxThreadsReachedBefore;
    private ProgressBar progressBar;
    private ScannerConfig scannerConfig;
    private GUIConfig guiConfig;
    private StateMachine stateMachine;
    private ResultTable resultTable;

    public StatusBar(Shell shell, GUIConfig guiConfig, ScannerConfig scannerConfig, ResultTable resultTable, StateMachine stateMachine) {
        this.guiConfig = guiConfig;
        this.scannerConfig = scannerConfig;
        this.stateMachine = stateMachine;
        this.resultTable = resultTable;
        this.resultTable.addListener(13, new ToolsActions.TableSelection(this, stateMachine));
        this.composite = new Composite(shell, 0);
        this.composite.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(100), null, new FormAttachment(100)));
        this.composite.setLayout(LayoutHelper.formLayout(1, 1, 2));
        this.statusText = new Label(this.composite, 2048);
        this.statusText.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(35), new FormAttachment(0), new FormAttachment(100)));
        this.setStatusText(null);
        this.displayMethodText = new Label(this.composite, 2048);
        this.displayMethodText.setText(Labels.getLabel("text.display." + (Object)((Object)GUIConfig.DisplayMethod.PORTS)));
        this.displayMethodText.pack();
        this.displayMethodText.setLayoutData(LayoutHelper.formData(this.displayMethodText.getSize().x, -1, new FormAttachment(this.statusText), null, new FormAttachment(0), new FormAttachment(100)));
        this.displayMethodText.addListener(3, new DisplayModeChangeListener());
        this.updateConfigText();
        this.threadsText = new Label(this.composite, 2048);
        this.setRunningThreads(Math.min(scannerConfig.maxThreads, 200));
        this.threadsText.pack();
        this.threadsText.setLayoutData(LayoutHelper.formData(this.threadsText.getSize().x, -1, new FormAttachment(this.displayMethodText), null, new FormAttachment(0), new FormAttachment(100)));
        this.setRunningThreads(0);
        this.progressBar = new ProgressBar(this.composite, 2048);
        this.progressBar.setLayoutData(LayoutHelper.formData(new FormAttachment(this.threadsText), new FormAttachment(100, 0), new FormAttachment(0), new FormAttachment(100)));
        this.progressBar.setSelection(0);
    }

    public void updateConfigText() {
        this.displayMethodText.setText(Labels.getLabel("text.display." + (Object)((Object)this.guiConfig.displayMethod)));
    }

    Composite getComposite() {
        return this.composite;
    }

    public boolean isDisposed() {
        return this.composite.isDisposed();
    }

    public void setStatusText(String statusText) {
        if (statusText == null) {
            statusText = Labels.getLabel("state.ready");
        }
        if (!this.statusText.isDisposed()) {
            this.statusText.setText(statusText);
        }
    }

    public void setRunningThreads(int runningThreads) {
        if (!this.threadsText.isDisposed()) {
            boolean maxThreadsReached;
            boolean bl = maxThreadsReached = runningThreads == this.scannerConfig.maxThreads;
            if (this.maxThreadsReachedBefore || maxThreadsReached) {
                Color newColor = this.threadsText.getDisplay().getSystemColor(maxThreadsReached ? 3 : 21);
                this.threadsText.setForeground(newColor);
            }
            this.maxThreadsReachedBefore = maxThreadsReached;
            this.threadsText.setText(Labels.getLabel("text.threads") + runningThreads + (maxThreadsReached ? Labels.getLabel("text.threads.max") : ""));
        }
    }

    public void setProgress(int progress) {
        if (!this.progressBar.isDisposed()) {
            this.progressBar.setSelection(progress);
        }
    }

    public Shell getShell() {
        return this.composite.getShell();
    }

    public void setEnabled(boolean enabled) {
        this.displayMethodText.setEnabled(enabled);
    }

    class DisplayModeChangeListener
    implements Listener {
        DisplayModeChangeListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (event.type == 3) {
                Menu popupMenu = new Menu(StatusBar.this.getShell(), 8);
                for (GUIConfig.DisplayMethod displayMethod : GUIConfig.DisplayMethod.values()) {
                    MenuItem item = new MenuItem(popupMenu, 0);
                    item.setText(Labels.getLabel("text.display." + (Object)((Object)displayMethod)));
                    item.setData((Object)displayMethod);
                    item.addListener(13, this);
                }
                popupMenu.setVisible(true);
            } else if (event.type == 13) {
                ((StatusBar)StatusBar.this).guiConfig.displayMethod = (GUIConfig.DisplayMethod)((Object)event.widget.getData());
                StatusBar.this.updateConfigText();
                if (!StatusBar.this.resultTable.getScanningResults().areResultsAvailable()) {
                    return;
                }
                switch (((StatusBar)StatusBar.this).guiConfig.displayMethod) {
                    case ALIVE: {
                        new ToolsActions.SelectDead(StatusBar.this.resultTable).handleEvent(event);
                        new CommandsMenuActions.Delete(StatusBar.this.resultTable, StatusBar.this.stateMachine).handleEvent(event);
                        break;
                    }
                    case PORTS: {
                        new ToolsActions.SelectWithoutPorts(StatusBar.this.resultTable).handleEvent(event);
                        new CommandsMenuActions.Delete(StatusBar.this.resultTable, StatusBar.this.stateMachine).handleEvent(event);
                    }
                }
            }
        }
    }
}

