/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azib.ipscan.config.OpenersConfig;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.UserErrorException;
import net.azib.ipscan.core.values.Empty;
import net.azib.ipscan.fetchers.FetcherRegistry;
import net.azib.ipscan.gui.actions.BrowserLauncher;
import net.azib.ipscan.gui.actions.TerminalLauncher;

public class OpenerLauncher {
    private final FetcherRegistry fetcherRegistry;
    private final ScanningResultList scanningResults;

    public OpenerLauncher(FetcherRegistry fetcherRegistry, ScanningResultList scanningResults) {
        this.fetcherRegistry = fetcherRegistry;
        this.scanningResults = scanningResults;
    }

    public void launch(OpenersConfig.Opener opener, int selectedItem) {
        String openerString = this.prepareOpenerStringForItem(opener.execString, selectedItem);
        if (openerString.startsWith("http:") || openerString.startsWith("https:") || openerString.startsWith("ftp:") || openerString.startsWith("mailto:") || openerString.startsWith("\\\\")) {
            BrowserLauncher.openURL(openerString);
        } else {
            try {
                if (opener.inTerminal) {
                    TerminalLauncher.launchInTerminal(openerString, opener.workingDir);
                } else if (Platform.LINUX) {
                    Runtime.getRuntime().exec(new String[]{"sh", "-c", openerString}, null, opener.workingDir);
                } else {
                    Runtime.getRuntime().exec(OpenerLauncher.splitCommand(openerString), null, opener.workingDir);
                }
            }
            catch (UserErrorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UserErrorException("opener.failed", openerString);
            }
        }
    }

    static String[] splitCommand(String command) {
        StringTokenizer tokenizer = new StringTokenizer(command);
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken(" \t");
            try {
                if (token.startsWith("\"")) {
                    token = token.substring(1) + tokenizer.nextToken("\"");
                    tokenizer.nextToken(" \t");
                } else if (token.startsWith("'")) {
                    token = token.substring(1) + tokenizer.nextToken("'");
                    tokenizer.nextToken(" \t");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    String prepareOpenerStringForItem(String openerString, int selectedItem) {
        Pattern paramsPattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = paramsPattern.matcher(openerString);
        StringBuffer sb = new StringBuffer(64);
        while (matcher.find()) {
            String fetcherId = matcher.group(1);
            Object scannedValue = this.getScannedValue(selectedItem, fetcherId);
            if (scannedValue == null || scannedValue instanceof Empty) {
                throw new UserErrorException("opener.nullFetcherValue", fetcherId);
            }
            matcher.appendReplacement(sb, scannedValue.toString());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private Object getScannedValue(int selectedItem, String fetcherId) {
        int fetcherIndex = this.fetcherRegistry.getSelectedFetcherIndex(fetcherId);
        if (fetcherIndex < 0) {
            throw new UserErrorException("opener.unknownFetcher", fetcherId);
        }
        Object value = this.scanningResults.getResult(selectedItem).getValues().get(fetcherIndex);
        if ((value == null || value instanceof Empty) && fetcherId.equals("fetcher.hostname")) {
            value = this.scanningResults.getResult(selectedItem).getAddress().getHostAddress();
        }
        return value;
    }
}

