/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.feeders;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.feeders.RandomFeeder;
import net.azib.ipscan.gui.actions.FeederActions;
import net.azib.ipscan.gui.feeders.AbstractFeederGUI;
import net.azib.ipscan.gui.feeders.FeederArea;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class RandomFeederGUI
extends AbstractFeederGUI {
    private Text ipPrototypeText;
    private Combo ipMaskCombo;
    private Spinner countSpinner;

    public RandomFeederGUI(FeederArea parent) {
        super(parent);
        this.feeder = new RandomFeeder();
    }

    @Override
    public void initialize() {
        this.setLayout(new GridLayout(5, false));
        Label ipPrototypeLabel = new Label(this, 0);
        this.ipPrototypeText = new Text(this, 2048);
        Label ipMaskLabel = new Label(this, 0);
        this.ipMaskCombo = new Combo(this, 0);
        Label hostnameLabel = new Label(this, 0);
        Text hostnameText = new Text(this, 2048);
        Button ipUpButton = new Button(this, 0);
        Label countLabel = new Label(this, 0);
        this.countSpinner = new Spinner(this, 2048);
        this.ipPrototypeText.setText("255.255.255.255xx");
        int textWidth = this.ipPrototypeText.computeSize((int)-1, (int)-1).x;
        this.ipPrototypeText.setText("");
        this.ipPrototypeText.setLayoutData(new GridData(textWidth, -1));
        ipPrototypeLabel.setText(Labels.getLabel("feeder.random.prototype") + ":");
        ipPrototypeLabel.setLayoutData(new GridData(128));
        ipMaskLabel.setText(Labels.getLabel("feeder.random.mask") + ":");
        this.ipMaskCombo.setVisibleItemCount(10);
        this.ipMaskCombo.add("255...128");
        this.ipMaskCombo.add("255...0");
        this.ipMaskCombo.add("255..0.0");
        this.ipMaskCombo.add("255.0.0.0");
        this.ipMaskCombo.add("0.0.0.0");
        this.ipMaskCombo.add("255..0.255");
        this.ipMaskCombo.add("255.0.0.255");
        this.ipMaskCombo.select(3);
        this.ipMaskCombo.setLayoutData(new GridData());
        ((GridData)this.ipMaskCombo.getLayoutData()).horizontalSpan = 2;
        hostnameLabel.setText(Labels.getLabel("feeder.random.hostname") + ":");
        ipMaskLabel.setLayoutData(new GridData(128));
        FeederActions.HostnameButton hostnameSelectionListener = new FeederActions.HostnameButton(hostnameText, this.ipPrototypeText, this.ipMaskCombo);
        hostnameText.addTraverseListener(hostnameSelectionListener);
        hostnameText.setLayoutData(new GridData(textWidth, -1));
        ipUpButton.setText(Labels.getLabel("button.ipUp"));
        ipUpButton.addSelectionListener(hostnameSelectionListener);
        countLabel.setText(Labels.getLabel("feeder.random.count"));
        this.countSpinner.setSelection(100);
        this.countSpinner.setMaximum(100000000);
        this.countSpinner.setMinimum(1);
        this.countSpinner.setLayoutData(new GridData(768));
        this.countSpinner.addTraverseListener(e -> {
            this.ipPrototypeText.forceFocus();
            this.countSpinner.forceFocus();
        });
        this.pack();
        this.asyncFillLocalHostInfo(hostnameText, this.ipPrototypeText);
    }

    @Override
    public Feeder createFeeder() {
        this.feeder = new RandomFeeder(this.ipPrototypeText.getText(), this.ipMaskCombo.getText(), this.countSpinner.getSelection());
        return this.feeder;
    }

    @Override
    public String[] serialize() {
        return new String[]{this.ipPrototypeText.getText(), this.ipMaskCombo.getText(), String.valueOf(this.countSpinner.getSelection())};
    }

    @Override
    public void unserialize(String[] parts) {
        this.ipPrototypeText.setText(parts[0]);
        this.ipMaskCombo.setText(parts[1]);
        this.countSpinner.setSelection(Integer.parseInt(parts[2]));
    }

    @Override
    public String[] serializePartsLabels() {
        return new String[]{"feeder.random.prototype", "feeder.random.mask", "feeder.random.count"};
    }
}

