/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.feeders;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.feeders.FeederException;
import net.azib.ipscan.feeders.RangeFeeder;
import net.azib.ipscan.gui.actions.FeederActions;
import net.azib.ipscan.gui.feeders.AbstractFeederGUI;
import net.azib.ipscan.gui.feeders.FeederArea;
import net.azib.ipscan.util.InetAddressUtils;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RangeFeederGUI
extends AbstractFeederGUI {
    private Text startIPText;
    private Text endIPText;
    private Text hostnameText;
    private Combo netmaskCombo;
    private boolean isEndIPUnedited = true;
    private boolean modifyListenersDisabled = false;

    public RangeFeederGUI(FeederArea parent) {
        super(parent);
        this.feeder = new RangeFeeder();
    }

    @Override
    public void initialize() {
        this.setLayout(new GridLayout(5, false));
        Label ipRangeLabel = new Label(this, 0);
        this.startIPText = new Text(this, 2048);
        Label toLabel = new Label(this, 0);
        this.endIPText = new Text(this, 2048);
        Label hostnameLabel = new Label(this, 0);
        this.hostnameText = new Text(this, 2048);
        Button ipUpButton = new Button(this, 0);
        this.netmaskCombo = new Combo(this, 0);
        this.startIPText.setText("255.255.255.255xx");
        int textWidth = this.startIPText.computeSize((int)-1, (int)-1).x;
        this.startIPText.setText("");
        this.startIPText.setLayoutData(new GridData(textWidth, -1));
        this.endIPText.setLayoutData(new GridData(textWidth, -1));
        this.hostnameText.setLayoutData(new GridData(textWidth, -1));
        this.netmaskCombo.setLayoutData(new GridData(768));
        ((GridData)this.endIPText.getLayoutData()).horizontalSpan = 2;
        GridData ipUpData = new GridData();
        ipUpData.horizontalSpan = 2;
        ipUpButton.setLayoutData(ipUpData);
        ipRangeLabel.setText(Labels.getLabel("feeder.range") + ":");
        ipRangeLabel.setLayoutData(new GridData(128));
        hostnameLabel.setText(Labels.getLabel("feeder.range.hostname") + ":");
        hostnameLabel.setLayoutData(new GridData(128));
        toLabel.setText(Labels.getLabel("feeder.range.to"));
        this.startIPText.addModifyListener(new StartIPModifyListener());
        this.endIPText.addKeyListener(new EndIPKeyListener());
        FeederActions.HostnameButton hostnameListener = new FeederActions.HostnameButton(this.hostnameText, this.startIPText, this.netmaskCombo){

            @Override
            public void widgetSelected(SelectionEvent event) {
                RangeFeederGUI.this.isEndIPUnedited = true;
                RangeFeederGUI.this.netmaskCombo.setText(Labels.getLabel("feeder.range.netmask"));
                super.widgetSelected(event);
            }
        };
        this.hostnameText.addTraverseListener(hostnameListener);
        this.hostnameText.setToolTipText(Labels.getLabel("feeder.range.hostname.tooltip"));
        NetmaskResetListener netmaskResetListener = new NetmaskResetListener();
        this.startIPText.addListener(24, netmaskResetListener);
        this.endIPText.addListener(24, netmaskResetListener);
        ipUpButton.setText(Labels.getLabel("button.ipUp"));
        ipUpButton.addSelectionListener(hostnameListener);
        this.netmaskCombo.setText(Labels.getLabel("feeder.range.netmask"));
        this.netmaskCombo.setVisibleItemCount(10);
        this.netmaskCombo.add("/26");
        this.netmaskCombo.add("/24");
        this.netmaskCombo.add("/16");
        this.netmaskCombo.add("255...192");
        this.netmaskCombo.add("255...128");
        this.netmaskCombo.add("255...0");
        this.netmaskCombo.add("255..0.0");
        this.netmaskCombo.add("255.0.0.0");
        NetmaskListener netmaskSelectionListener = new NetmaskListener();
        this.netmaskCombo.addListener(13, netmaskSelectionListener);
        this.netmaskCombo.addListener(31, netmaskSelectionListener);
        this.netmaskCombo.setToolTipText(Labels.getLabel("feeder.range.netmask.tooltip"));
        this.pack();
        this.asyncFillLocalHostInfo(this.hostnameText, this.startIPText);
    }

    @Override
    public Feeder createFeeder() {
        this.feeder = new RangeFeeder(this.startIPText.getText(), this.endIPText.getText());
        return this.feeder;
    }

    @Override
    public String[] serialize() {
        return new String[]{this.startIPText.getText(), this.endIPText.getText()};
    }

    @Override
    public void unserialize(String[] parts) {
        this.startIPText.setText(parts[0]);
        this.endIPText.setText(parts[1]);
        this.netmaskCombo.setText(Labels.getLabel("feeder.range.netmask"));
    }

    @Override
    public String[] serializePartsLabels() {
        return new String[]{"feeder.range.startIP", "feeder.range.endIP"};
    }

    private void updateStartEndWithNetmask(InetAddress ip, String netmaskString) {
        try {
            InetAddress netmask = InetAddressUtils.parseNetmask(netmaskString);
            this.modifyListenersDisabled = true;
            this.startIPText.setText(InetAddressUtils.startRangeByNetmask(ip, netmask).getHostAddress());
            this.endIPText.setText(InetAddressUtils.endRangeByNetmask(ip, netmask).getHostAddress());
            this.modifyListenersDisabled = false;
            this.isEndIPUnedited = false;
        }
        catch (UnknownHostException e) {
            LOG.fine(e.toString());
        }
    }

    @Override
    protected void afterLocalHostInfoFilled(InterfaceAddress localInterface) {
        InetAddress address = localInterface.getAddress();
        if (!address.isLoopbackAddress()) {
            this.updateStartEndWithNetmask(address, "/" + localInterface.getNetworkPrefixLength());
            this.isEndIPUnedited = true;
        }
    }

    final class NetmaskListener
    implements Listener {
        NetmaskListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (event.type == 31) {
                if (event.detail != 4) {
                    return;
                }
                event.doit = false;
            }
            if (event.type == 13) {
                if (RangeFeederGUI.this.netmaskCombo.indexOf(RangeFeederGUI.this.netmaskCombo.getText()) < 0) {
                    return;
                }
                if (Platform.WINDOWS && RangeFeederGUI.this.netmaskCombo.getListVisible()) {
                    return;
                }
            }
            try {
                String netmaskString = RangeFeederGUI.this.netmaskCombo.getText();
                InetAddress startIP = InetAddress.getByName(RangeFeederGUI.this.startIPText.getText());
                RangeFeederGUI.this.updateStartEndWithNetmask(startIP, netmaskString);
            }
            catch (UnknownHostException e) {
                throw new FeederException("invalidNetmask");
            }
            if (event.type == 31) {
                RangeFeederGUI.this.getParent().forceFocus();
            } else {
                RangeFeederGUI.this.netmaskCombo.forceFocus();
            }
        }
    }

    final class StartIPModifyListener
    implements ModifyListener {
        StartIPModifyListener() {
        }

        @Override
        public void modifyText(ModifyEvent e) {
            if (RangeFeederGUI.this.isEndIPUnedited) {
                RangeFeederGUI.this.endIPText.setText(RangeFeederGUI.this.startIPText.getText());
            }
        }
    }

    final class NetmaskResetListener
    implements Listener {
        NetmaskResetListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (!RangeFeederGUI.this.modifyListenersDisabled) {
                RangeFeederGUI.this.netmaskCombo.setText(Labels.getLabel("feeder.range.netmask"));
            }
        }
    }

    final class EndIPKeyListener
    implements KeyListener {
        EndIPKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            RangeFeederGUI.this.isEndIPUnedited = false;
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

