/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.fetchers;

import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherPrefs;
import net.azib.ipscan.fetchers.PortTextFetcher;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PortTextFetcherPrefs
extends AbstractModalDialog
implements FetcherPrefs {
    private PortTextFetcher fetcher;
    private Text textToSend;
    private Text matchingRegexp;
    private Text extractGroup;

    @Override
    public void openFor(Fetcher fetcher) {
        this.fetcher = (PortTextFetcher)fetcher;
        this.open();
    }

    @Override
    protected void populateShell() {
        this.shell = new Shell(Display.getCurrent().getActiveShell(), 2144);
        this.shell.setText(this.fetcher.getName());
        this.shell.setLayout(LayoutHelper.formLayout(10, 10, 5));
        Label sendLabel = new Label(this.shell, 0);
        sendLabel.setText(Labels.getLabel("text.fetcher.portText.send"));
        this.textToSend = new Text(this.shell, 2048);
        this.textToSend.setText(PortTextFetcherPrefs.toEditableText(this.fetcher.getTextToSend()));
        this.textToSend.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(100), new FormAttachment(sendLabel), null));
        Label matchLabel = new Label(this.shell, 0);
        matchLabel.setText(Labels.getLabel("text.fetcher.portText.match"));
        matchLabel.setLayoutData(LayoutHelper.formData(new FormAttachment(0), null, new FormAttachment(this.textToSend), null));
        this.matchingRegexp = new Text(this.shell, 2048);
        this.matchingRegexp.setText(this.fetcher.getMatchingRegexp().pattern());
        this.matchingRegexp.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(this.textToSend, 0, 131072), new FormAttachment(matchLabel), null));
        Label replaceLabel = new Label(this.shell, 0);
        replaceLabel.setText(Labels.getLabel("text.fetcher.portText.replace"));
        replaceLabel.setLayoutData(LayoutHelper.formData(new FormAttachment(0), null, new FormAttachment(this.matchingRegexp), null));
        this.extractGroup = new Text(this.shell, 2048);
        this.extractGroup.setText("$1");
        this.extractGroup.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(this.textToSend, 0, 131072), new FormAttachment(replaceLabel), null));
        Button okButton = new Button(this.shell, 0);
        okButton.setText(Labels.getLabel("button.OK"));
        Button cancelButton = new Button(this.shell, 0);
        cancelButton.setText(Labels.getLabel("button.cancel"));
        this.positionButtonsInFormLayout(okButton, cancelButton, this.extractGroup);
        okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PortTextFetcherPrefs.this.savePreferences();
                PortTextFetcherPrefs.this.shell.close();
            }
        });
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PortTextFetcherPrefs.this.shell.close();
            }
        });
        this.shell.pack();
    }

    void savePreferences() {
        Preferences prefs = this.fetcher.getPreferences();
        String text = PortTextFetcherPrefs.toRealText(this.textToSend.getText());
        this.fetcher.setTextToSend(text);
        prefs.put("textToSend", text);
        this.fetcher.setMatchingRegexp(Pattern.compile(this.matchingRegexp.getText()));
        prefs.put("matchingRegexp", this.fetcher.getMatchingRegexp().pattern());
        this.fetcher.setExtractGroup(Integer.parseInt(this.extractGroup.getText().replace("$", "")));
        prefs.putInt("extractGroup", this.fetcher.getExtractGroup());
    }

    static String toEditableText(String s) {
        StringBuilder t = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == '\n') {
                t.append("\\n");
                continue;
            }
            if (c == '\r') {
                t.append("\\r");
                continue;
            }
            if (c == '\t') {
                t.append("\\t");
                continue;
            }
            if (c < '\n') {
                t.append("\\x0").append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            if (c < ' ') {
                t.append("\\x").append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            t.append(c);
        }
        return t.toString();
    }

    static String toRealText(String s) {
        if ((s = s.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t")).contains("\\x")) {
            StringBuffer t = new StringBuffer();
            Matcher m = Pattern.compile("\\\\x(\\d{2})").matcher(s);
            while (m.find()) {
                m.appendReplacement(t, new String(new char[]{(char)Integer.parseInt(m.group(1), 16)}));
            }
            m.appendTail(t);
            s = t.toString();
        }
        return s;
    }
}

