/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.azib.ipscan.config.LoggerFactory;

public class InetAddressUtils {
    static final Logger LOG = LoggerFactory.getLogger();
    public static final Pattern HOSTNAME_REGEX = Pattern.compile("\\b((([a-z]|[a-z0-9][a-z0-9\\-]*[a-z0-9])\\.)+([a-z]{2,})|\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})\\b", 2);

    public static InetAddress startRangeByNetmask(InetAddress address, InetAddress netmask) {
        byte[] netmaskBytes = netmask.getAddress();
        byte[] addressBytes = address.getAddress();
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = (byte)(addressBytes[i] & netmaskBytes[i]);
        }
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static InetAddress endRangeByNetmask(InetAddress address, InetAddress netmask) {
        byte[] netmaskBytes = netmask.getAddress();
        byte[] addressBytes = address.getAddress();
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = (byte)(addressBytes[i] | ~netmaskBytes[i]);
        }
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean greaterThan(InetAddress inetAddress1, InetAddress inetAddress2) {
        byte[] address1 = inetAddress1.getAddress();
        byte[] address2 = inetAddress2.getAddress();
        for (int i = 0; i < address1.length; ++i) {
            if ((address1[i] & 0xFF) > (address2[i] & 0xFF)) {
                return true;
            }
            if ((address1[i] & 0xFF) < (address2[i] & 0xFF)) break;
        }
        return false;
    }

    public static InetAddress increment(InetAddress address) {
        return InetAddressUtils.modifyInetAddress(address, true);
    }

    public static InetAddress decrement(InetAddress address) {
        return InetAddressUtils.modifyInetAddress(address, false);
    }

    private static InetAddress modifyInetAddress(InetAddress address, boolean isIncrement) {
        try {
            byte[] newAddress = address.getAddress();
            for (int i = newAddress.length - 1; i >= 0; --i) {
                if (isIncrement) {
                    int n = i;
                    newAddress[n] = (byte)(newAddress[n] + 1);
                    if (newAddress[n] == 0) continue;
                    break;
                }
                int n = i;
                newAddress[n] = (byte)(newAddress[n] - 1);
                if (newAddress[n] != 0) break;
            }
            return InetAddress.getByAddress(newAddress);
        }
        catch (UnknownHostException e) {
            assert (false) : e;
            return null;
        }
    }

    public static InetAddress parseNetmask(String netmaskString) throws UnknownHostException {
        if (netmaskString.startsWith("/")) {
            int totalBits = Integer.parseInt(netmaskString.substring(1));
            byte[] mask = new byte[4];
            for (int i = 0; i < mask.length; ++i) {
                int curByteBits = totalBits >= 8 ? 8 : totalBits;
                totalBits -= curByteBits;
                mask[i] = (byte)((1 << curByteBits) - 1 << 8 - curByteBits & 0xFF);
            }
            return InetAddress.getByAddress(mask);
        }
        netmaskString = netmaskString.replaceAll("\\.\\.", ".255.");
        netmaskString = netmaskString.replaceAll("\\.\\.", ".255.");
        return InetAddress.getByName(netmaskString);
    }

    public static void maskPrototypeAddressBytes(byte[] addressBytes, byte[] maskBytes, byte[] prototypeBytes) {
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = (byte)(addressBytes[i] & ~maskBytes[i] | prototypeBytes[i] & maskBytes[i]);
        }
    }

    public static boolean isLikelyBroadcast(InetAddress address) {
        byte[] bytes = address.getAddress();
        return bytes[bytes.length - 1] == 0 || bytes[bytes.length - 1] == -1;
    }

    public static InterfaceAddress getLocalInterface() {
        InterfaceAddress anyAddress = null;
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            Collections.reverse(interfaces);
            for (NetworkInterface networkInterface : interfaces) {
                Iterator<InterfaceAddress> iterator = networkInterface.getInterfaceAddresses().iterator();
                while (iterator.hasNext()) {
                    InterfaceAddress ifAddr;
                    anyAddress = ifAddr = iterator.next();
                    InetAddress addr = ifAddr.getAddress();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return ifAddr;
                }
            }
        }
        catch (SocketException e) {
            LOG.log(Level.FINE, "Cannot enumerate network interfaces", e);
        }
        return anyAddress;
    }
}

