/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class NetBIOSResolver
implements Closeable {
    private static final byte[] REQUEST_DATA = new byte[]{-94, 72, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 32, 67, 75, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 0, 0, 33, 0, 1};
    DatagramSocket socket = new DatagramSocket();

    public NetBIOSResolver(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public String[] resolve(InetAddress ip) throws IOException {
        this.socket.send(new DatagramPacket(REQUEST_DATA, REQUEST_DATA.length, ip, 137));
        byte[] response = new byte[1024];
        DatagramPacket responsePacket = new DatagramPacket(response, response.length);
        this.socket.receive(responsePacket);
        if (responsePacket.getLength() < 57) {
            return null;
        }
        int nameCount = response[56] & 0xFF;
        if (responsePacket.getLength() < 57 + 18 * (nameCount - 1)) {
            return null;
        }
        return NetBIOSResolver.extractNames(response, nameCount);
    }

    static String[] extractNames(byte[] response, int nameCount) {
        String computerName = NetBIOSResolver.name(response, 0);
        String groupName = null;
        for (int i = 1; i < nameCount; ++i) {
            if (NetBIOSResolver.nameType(response, i) != 0 || (NetBIOSResolver.nameFlag(response, i) & 0x80) <= 0) continue;
            groupName = NetBIOSResolver.name(response, i);
            break;
        }
        String userName = null;
        for (int i = nameCount - 1; i > 0; --i) {
            if (NetBIOSResolver.nameType(response, i) != 3) continue;
            userName = NetBIOSResolver.name(response, i);
            break;
        }
        String macAddress = String.format("%02X-%02X-%02X-%02X-%02X-%02X", NetBIOSResolver.nameByte(response, nameCount, 0), NetBIOSResolver.nameByte(response, nameCount, 1), NetBIOSResolver.nameByte(response, nameCount, 2), NetBIOSResolver.nameByte(response, nameCount, 3), NetBIOSResolver.nameByte(response, nameCount, 4), NetBIOSResolver.nameByte(response, nameCount, 5));
        return new String[]{computerName, userName, groupName, macAddress};
    }

    private static String name(byte[] response, int i) {
        return new String(response, 57 + 18 * i, 15).trim();
    }

    private static int nameByte(byte[] response, int i, int n) {
        return response[57 + 18 * i + n] & 0xFF;
    }

    private static int nameFlag(byte[] response, int i) {
        return response[57 + 18 * i + 15 + 1] & 255 + (response[57 + 18 * i + 15 + 2] & 0xFF) * 255;
    }

    private static int nameType(byte[] response, int i) {
        return response[57 + 18 * i + 15] & 0xFF;
    }

    @Override
    public void close() {
        this.socket.close();
    }
}

