/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    boolean disposed;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_TRANSPARENT;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    NSMutableParagraphStyle paragraphStyle;
    Point dpi;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            if (NSThread.isMainThread()) {
                NSString key;
                NSAutoreleasePool pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                NSThread nsthread = NSThread.currentThread();
                NSMutableDictionary dictionary = nsthread.threadDictionary();
                id obj = dictionary.objectForKey(key = NSString.stringWith("SWT_NSAutoreleasePool"));
                if (obj == null) {
                    NSNumber nsnumber = NSNumber.numberWithInteger(pool.id);
                    dictionary.setObject(nsnumber, key);
                } else {
                    pool.release();
                }
            }
            this.create(data);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != object) continue;
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
        }
    }

    protected void destroy() {
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    NSScreen getPrimaryScreen() {
        NSArray screens = NSScreen.screens();
        return screens != null ? new NSScreen(screens.objectAtIndex(0L)) : null;
    }

    Point getScreenDPI() {
        NSScreen screen = this.getPrimaryScreen();
        if (screen == null) {
            return new Point(0, 0);
        }
        NSDictionary dictionary = screen.deviceDescription();
        NSValue value = new NSValue(dictionary.objectForKey((id)new id((long)OS.NSDeviceResolution())).id);
        NSSize size = value.sizeValue();
        double scaling = screen.backingScaleFactor();
        return new Point((int)(size.width / scaling), (int)(size.height / scaling));
    }

    public Color getSystemColor(int id2) {
        this.checkDevice();
        switch (id2) {
            case 37: {
                return this.COLOR_TRANSPARENT;
            }
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    protected void init() {
        this.COLOR_TRANSPARENT = new Color(this, 255, 255, 255, 0);
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        this.paragraphStyle.setAlignment(0L);
        this.paragraphStyle.setLineBreakMode(2L);
        NSArray tabs = new NSArray(new NSArray().alloc().init());
        this.paragraphStyle.setTabStops(tabs);
        tabs.release();
        boolean smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        double systemFontSize = smallFonts ? NSFont.smallSystemFontSize() : NSFont.systemFontSize();
        Point dpi = this.dpi = this.getDPI();
        Point screenDPI = this.getScreenDPI();
        NSFont font = NSFont.systemFontOfSize(systemFontSize * (double)dpi.y / (double)screenDPI.y);
        font.retain();
        this.systemFont = Font.cocoa_new(this, font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != null) continue;
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int objectCount = 0;
                int colors = 0;
                int cursors = 0;
                int fonts = 0;
                int gcs = 0;
                int images = 0;
                int paths = 0;
                int patterns = 0;
                int regions = 0;
                int textLayouts = 0;
                int transforms = 0;
                for (int i = 0; i < this.objects.length; ++i) {
                    Object object2 = this.objects[i];
                    if (object2 == null) continue;
                    ++objectCount;
                    if (object2 instanceof Color) {
                        ++colors;
                    }
                    if (object2 instanceof Cursor) {
                        ++cursors;
                    }
                    if (object2 instanceof Font) {
                        ++fonts;
                    }
                    if (object2 instanceof GC) {
                        ++gcs;
                    }
                    if (object2 instanceof Image) {
                        ++images;
                    }
                    if (object2 instanceof Path) {
                        ++paths;
                    }
                    if (object2 instanceof Pattern) {
                        ++patterns;
                    }
                    if (object2 instanceof Region) {
                        ++regions;
                    }
                    if (object2 instanceof TextLayout) {
                        ++textLayouts;
                    }
                    if (!(object2 instanceof Transform)) continue;
                    ++transforms;
                }
                if (objectCount != 0) {
                    String string = "Summary: ";
                    if (colors != 0) {
                        string = string + colors + " Color(s), ";
                    }
                    if (cursors != 0) {
                        string = string + cursors + " Cursor(s), ";
                    }
                    if (fonts != 0) {
                        string = string + fonts + " Font(s), ";
                    }
                    if (gcs != 0) {
                        string = string + gcs + " GC(s), ";
                    }
                    if (images != 0) {
                        string = string + images + " Image(s), ";
                    }
                    if (paths != 0) {
                        string = string + paths + " Path(s), ";
                    }
                    if (patterns != 0) {
                        string = string + patterns + " Pattern(s), ";
                    }
                    if (regions != 0) {
                        string = string + regions + " Region(s), ";
                    }
                    if (textLayouts != 0) {
                        string = string + textLayouts + " TextLayout(s), ";
                    }
                    if (transforms != 0) {
                        string = string + transforms + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.out.println(string);
                    }
                    for (int i = 0; i < this.errors.length; ++i) {
                        if (this.errors[i] == null) continue;
                        this.errors[i].printStackTrace(System.out);
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.paragraphStyle != null) {
            this.paragraphStyle.release();
        }
        this.paragraphStyle = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    protected int getDeviceZoom() {
        NSScreen mainScreen = NSScreen.mainScreen();
        int scaleFactor = mainScreen != null ? (int)mainScreen.backingScaleFactor() : 1;
        return scaleFactor * 100;
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

