/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontManager;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;

public final class Font
extends Resource {
    public NSFont handle;
    public int extraTraits;
    FontMetrics metrics = null;

    Font(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font(Device device, FontData fd) {
        super(device);
        if (fd == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(fd.getName(), fd.getHeightF(), fd.getStyle(), fd.nsName);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font(Device device, String name, int height, int style) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(name, height, style, null);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    @Override
    void destroy() {
        this.handle.release();
        this.handle = null;
        this.metrics = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.handle == font.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSString family = this.handle.familyName();
            String name = family.getString();
            NSString str = this.handle.fontName();
            String nsName = str.getString();
            NSFontManager manager = NSFontManager.sharedFontManager();
            long traits = manager.traitsOfFont(this.handle);
            int style = 0;
            if ((traits & 1L) != 0L) {
                style |= 2;
            }
            if ((traits & 2L) != 0L) {
                style |= 1;
            }
            if ((this.extraTraits & 1) != 0) {
                style |= 2;
            }
            if ((this.extraTraits & 2) != 0) {
                style |= 1;
            }
            Point dpi = this.device.dpi;
            Point screenDPI = this.device.getScreenDPI();
            FontData data = new FontData(name, (float)this.handle.pointSize() * (float)screenDPI.y / (float)dpi.y, style);
            data.nsName = nsName;
            FontData[] fontDataArray = new FontData[]{data};
            return fontDataArray;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public static Font cocoa_new(Device device, NSFont handle) {
        Font font = new Font(device);
        font.handle = handle;
        return font;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(String name, float height, int style, String nsName) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0.0f) {
            SWT.error(5);
        }
        Point dpi = this.device.dpi;
        Point screenDPI = this.device.getScreenDPI();
        float size = height * (float)dpi.y / (float)screenDPI.y;
        NSFont systemFont = NSFont.systemFontOfSize(size);
        NSFont boldSystemFont = NSFont.boldSystemFontOfSize(size);
        String systemFontName = systemFont.familyName().getString();
        String boldSystemFontName = boldSystemFont.familyName().getString();
        if (systemFontName.equals(name) || boldSystemFontName.equals(name)) {
            this.handle = (style & 1) == 0 ? systemFont : boldSystemFont;
        } else if (nsName != null) {
            this.handle = NSFont.fontWithName(NSString.stringWith(nsName), size);
        } else {
            NSString family = NSString.stringWith(name);
            this.handle = NSFont.fontWithName(family, size);
        }
        this.initTraits(style, systemFont);
        this.handle.retain();
    }

    private void initTraits(int style, NSFont systemFont) {
        NSFontManager manager = NSFontManager.sharedFontManager();
        if (this.handle != null && (manager.traitsOfFont(this.handle) & 2L) == 0L && (style & 1) != 0) {
            this.handle = manager.convertFont(this.handle, 2L);
        }
        if (this.handle != null && (manager.traitsOfFont(this.handle) & 1L) == 0L && (style & 2) != 0) {
            this.handle = manager.convertFont(this.handle, 1L);
        }
        if (this.handle == null) {
            this.handle = systemFont;
        }
        if ((style & 2) != 0 && (manager.traitsOfFont(this.handle) & 1L) == 0L) {
            this.extraTraits |= 1;
        }
        if ((style & 1) != 0 && (manager.traitsOfFont(this.handle) & 2L) == 0L) {
            this.extraTraits |= 2;
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

