/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.graphics.ImageUtil;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public NSImage handle;
    GC memGC;
    int width = -1;
    int height = -1;
    private ImageFileNameProvider imageFileNameProvider;
    private ImageDataProvider imageDataProvider;
    private int styleFlag = 0;
    private AlphaInfo alphaInfo_100;
    private AlphaInfo alphaInfo_200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, InputStream stream) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(new ImageData(stream));
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        this.imageDataProvider = imageDataProvider;
        ImageData data = imageDataProvider.getImageData(100);
        if (data == null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(data);
            this.init();
            ImageData data2x = imageDataProvider.getImageData(200);
            if (data2x != null) {
                this.alphaInfo_200 = new AlphaInfo();
                NSBitmapImageRep rep = this.createRepresentation(data2x, this.alphaInfo_200);
                this.handle.addRepresentation(rep);
                rep.release();
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    ImageData _getImageData(NSBitmapImageRep imageRep, AlphaInfo info) {
        long width = imageRep.pixelsWide();
        long height = imageRep.pixelsHigh();
        long bpr = imageRep.bytesPerRow();
        long bpp = imageRep.bitsPerPixel();
        long bitmapData = imageRep.bitmapData();
        long bitmapFormat = imageRep.bitmapFormat();
        long dataSize = height * bpr;
        byte[] srcData = new byte[(int)dataSize];
        C.memmove(srcData, bitmapData, dataSize);
        PaletteData palette = bpp == 32L && (bitmapFormat & 1L) == 0L ? new PaletteData(-16777216, 0xFF0000, 65280) : new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData((int)width, (int)height, (int)bpp, palette, 1, srcData);
        data.bytesPerLine = (int)bpr;
        if (imageRep.hasAlpha() && info.transparentPixel == -1 && info.alpha == -1 && info.alphaData == null) {
            byte[] alphaD = new byte[(int)(dataSize / 4L)];
            int offset = (bitmapFormat & 1L) != 0L ? 0 : 3;
            int a = 0;
            for (int i = offset; i < srcData.length && a < alphaD.length; i += 4, ++a) {
                alphaD[a] = srcData[i];
            }
            data.alphaData = alphaD;
        } else {
            data.transparentPixel = info.transparentPixel;
            if (info.transparentPixel == -1 && this.type == 1) {
                int maskPad = 2;
                long maskBpl = ((width + 7L) / 8L + (long)(maskPad - 1)) / (long)maskPad * (long)maskPad;
                byte[] maskData = new byte[(int)(height * maskBpl)];
                int offset = 0;
                int maskOffset = 0;
                int y = 0;
                while ((long)y < height) {
                    int x = 0;
                    while ((long)x < width) {
                        if (srcData[offset] != 0) {
                            int n = maskOffset + (x >> 3);
                            maskData[n] = (byte)(maskData[n] | 1 << 7 - (x & 7));
                        } else {
                            int n = maskOffset + (x >> 3);
                            maskData[n] = (byte)(maskData[n] & ~(1 << 7 - (x & 7)));
                        }
                        offset += 4;
                        ++x;
                    }
                    maskOffset = (int)((long)maskOffset + maskBpl);
                    ++y;
                }
                data.maskData = maskData;
                data.maskPad = maskPad;
            }
            data.alpha = info.alpha;
            if (info.alpha == -1 && info.alphaData != null) {
                data.alphaData = new byte[info.alphaData.length];
                System.arraycopy(info.alphaData, 0, data.alphaData, 0, info.alphaData.length);
            }
        }
        if (bpp == 32L) {
            int offset;
            for (int i = offset = (bitmapFormat & 1L) != 0L ? 0 : 3; i < srcData.length; i += 4) {
                srcData[i] = 0;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAlpha() {
        AlphaInfo info = this.alphaInfo_100;
        if (info.transparentPixel == -1 && info.alpha == -1 && info.alphaData == null) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep imageRep = this.getRepresentation();
            long height = imageRep.pixelsHigh();
            long bpr = imageRep.bytesPerRow();
            long bitmapData = imageRep.bitmapData();
            long format = imageRep.bitmapFormat();
            long dataSize = height * bpr;
            byte[] srcData = new byte[(int)dataSize];
            C.memmove(srcData, bitmapData, dataSize);
            if (info.transparentPixel != -1) {
                if ((format & 1L) != 0L) {
                    int i = 0;
                    while ((long)i < dataSize) {
                        int pixel = (srcData[i + 1] & 0xFF) << 16 | (srcData[i + 2] & 0xFF) << 8 | srcData[i + 3] & 0xFF;
                        srcData[i] = (byte)(pixel == info.transparentPixel ? 0 : 255);
                        i += 4;
                    }
                } else {
                    int i = 0;
                    while ((long)i < dataSize) {
                        int pixel = (srcData[i + 0] & 0xFF) << 16 | (srcData[i + 1] & 0xFF) << 8 | srcData[i + 2] & 0xFF;
                        srcData[i] = (byte)(pixel == info.transparentPixel ? 0 : 255);
                        i += 4;
                    }
                }
            } else if (info.alpha != -1) {
                int i;
                byte a = (byte)info.alpha;
                int n = i = (format & 1L) != 0L ? 0 : 3;
                while ((long)i < dataSize) {
                    srcData[i] = a;
                    i += 4;
                }
            } else {
                long width = imageRep.pixelsWide();
                int offset = 0;
                int alphaOffset = (format & 1L) != 0L ? 0 : 3;
                int y = 0;
                while ((long)y < height) {
                    int x = 0;
                    while ((long)x < width && alphaOffset < info.alphaData.length && offset < srcData.length) {
                        srcData[offset] = info.alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                        ++x;
                    }
                    ++y;
                }
            }
            imageRep.setAlpha(true);
            C.memmove(bitmapData, srcData, dataSize);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    private NSBitmapImageRep createRepresentation(ImageData imageData, AlphaInfo alphaInfo) {
        boolean hasAlpha;
        RGB rgb;
        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        PaletteData palette = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || palette.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        int dataSize = imageData.width * imageData.height * 4;
        int bpr = imageData.width * 4;
        byte[] buffer = new byte[dataSize];
        if (palette.isDirect) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rgbs = palette.getRGBs();
            int length = rgbs.length;
            byte[] srcReds = new byte[length];
            byte[] srcGreens = new byte[length];
            byte[] srcBlues = new byte[length];
            for (int i = 0; i < rgbs.length; ++i) {
                rgb = rgbs[i];
                if (rgb == null) continue;
                srcReds[i] = (byte)rgb.red;
                srcGreens[i] = (byte)rgb.green;
                srcBlues[i] = (byte)rgb.blue;
            }
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, imageData.width, imageData.height, 0xFF0000, 65280, 255, false, false);
        }
        int transparency = imageData.getTransparencyType();
        boolean bl = hasAlpha = transparency != 0;
        if (transparency == 2 || imageData.transparentPixel != -1) {
            int n = this.type = imageData.transparentPixel != -1 ? 0 : 1;
            if (imageData.transparentPixel != -1) {
                int transRed = 0;
                int transGreen = 0;
                int transBlue = 0;
                if (palette.isDirect) {
                    RGB rgb2 = palette.getRGB(imageData.transparentPixel);
                    transRed = rgb2.red;
                    transGreen = rgb2.green;
                    transBlue = rgb2.blue;
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    if (imageData.transparentPixel < rgbs.length) {
                        rgb = rgbs[imageData.transparentPixel];
                        transRed = rgb.red;
                        transGreen = rgb.green;
                        transBlue = rgb.blue;
                    }
                }
                alphaInfo.transparentPixel = transRed << 16 | transGreen << 8 | transBlue;
            }
            ImageData maskImage = imageData.getTransparencyMask();
            byte[] maskData = maskImage.data;
            int maskBpl = maskImage.bytesPerLine;
            int offset = 0;
            int maskOffset = 0;
            for (int y = 0; y < imageData.height; ++y) {
                for (int x = 0; x < imageData.width; ++x) {
                    buffer[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                    offset += 4;
                }
                maskOffset += maskBpl;
            }
        } else {
            this.type = 0;
            if (imageData.alpha != -1) {
                hasAlpha = true;
                alphaInfo.alpha = imageData.alpha;
                byte a = (byte)alphaInfo.alpha;
                for (int dataIndex = 0; dataIndex < buffer.length; dataIndex += 4) {
                    buffer[dataIndex] = a;
                }
            } else if (imageData.alphaData != null) {
                hasAlpha = true;
                alphaInfo.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, alphaInfo.alphaData, 0, alphaInfo.alphaData.length);
                int offset = 0;
                int alphaOffset = 0;
                for (int y = 0; y < imageData.height; ++y) {
                    for (int x = 0; x < imageData.width; ++x) {
                        buffer[offset] = alphaInfo.alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                    }
                }
            }
        }
        rep = rep.initWithBitmapDataPlanes(0L, imageData.width, imageData.height, 8L, hasAlpha ? 4L : 3L, hasAlpha, false, OS.NSDeviceRGBColorSpace, 3L, bpr, 32L);
        C.memmove(rep.bitmapData(), buffer, (long)dataSize);
        return rep;
    }

    @Override
    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        this.handle.release();
        this.handle = null;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.alphaInfo_100.transparentPixel != image.alphaInfo_100.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        return this.handle == image.handle;
    }

    NSBitmapImageRep getRepresentation_100() {
        NSArray reps = this.handle.representations();
        NSSize size = this.handle.size();
        long count = reps.count();
        int i = 0;
        while ((long)i < count) {
            NSBitmapImageRep rep = new NSBitmapImageRep(reps.objectAtIndex(i));
            if ((long)((int)size.width) == rep.pixelsWide() && (long)((int)size.height) == rep.pixelsHigh() && rep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return rep;
            }
            ++i;
        }
        NSBitmapImageRep newRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        newRep = newRep.initWithData(this.handle.TIFFRepresentation());
        newRep.setSize(size);
        this.handle.addRepresentation(newRep);
        newRep.release();
        return newRep;
    }

    NSBitmapImageRep getRepresentation_200() {
        NSArray reps = this.handle.representations();
        NSSize size = this.handle.size();
        long count = reps.count();
        NSObject bestRep = null;
        int width = (int)size.width * 2;
        int height = (int)size.height * 2;
        int i = 0;
        while ((long)i < count) {
            NSBitmapImageRep rep = new NSBitmapImageRep(reps.objectAtIndex(i));
            if ((long)width == rep.pixelsWide() && (long)height == rep.pixelsHigh()) {
                if (rep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                    return rep;
                }
                if (bestRep == null) {
                    bestRep = rep;
                }
            }
            ++i;
        }
        if (bestRep != null) {
            bestRep.retain();
            i = 0;
            while ((long)i < count) {
                this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0L)));
                ++i;
            }
            this.handle.addRepresentation((NSImageRep)bestRep);
            NSBitmapImageRep newRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            newRep = newRep.initWithData(this.handle.TIFFRepresentation());
            this.handle.addRepresentation(newRep);
            this.handle.removeRepresentation((NSImageRep)bestRep);
            bestRep.release();
            newRep.release();
            return newRep;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.width != -1 && this.height != -1) {
                Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
                return rectangle;
            }
            NSSize size = this.handle.size();
            this.width = (int)size.width;
            this.height = (int)size.height;
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            boolean hasImageProvider;
            boolean bl = hasImageProvider = this.imageFileNameProvider != null || this.imageDataProvider != null;
            if (zoom == 100) {
                if (hasImageProvider) {
                    NSBitmapImageRep imageRep = this.getRepresentation_100();
                    ImageData imageData = this._getImageData(imageRep, this.alphaInfo_100);
                    return imageData;
                }
                NSBitmapImageRep imageRep = this.getRepresentation();
                if (imageRep.pixelsHigh() == (long)this.height) {
                    ImageData imageData = this._getImageData(imageRep, this.alphaInfo_100);
                    return imageData;
                }
                if (this.alphaInfo_200 == null) {
                    this.initAlpha_200(imageRep);
                }
                NSArray reps = this.handle.representations();
                long count = reps.count();
                int i = 0;
                while ((long)i < count) {
                    this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0L)));
                    ++i;
                }
                this.handle.addRepresentation(imageRep);
                NSSize targetSize = this.handle.size();
                imageRep = this.createImageRep(targetSize);
                this.initAlpha_100(imageRep);
                ImageData imageData = this._getImageData(imageRep, this.alphaInfo_100);
                return imageData;
            }
            if (zoom == 200) {
                NSBitmapImageRep imageRep200 = this.getRepresentation_200();
                if (imageRep200 == null) {
                    NSSize imgSize = this.handle.size();
                    NSSize targetSize = new NSSize();
                    targetSize.height = imgSize.height * 2.0;
                    targetSize.width = imgSize.width * 2.0;
                    imageRep200 = this.createImageRep(targetSize);
                }
                if (this.alphaInfo_100.alphaData != null && this.alphaInfo_200 != null && this.alphaInfo_200.alphaData == null) {
                    this.initAlpha_200(imageRep200);
                }
                if (this.alphaInfo_200 == null) {
                    this.initAlpha_200(imageRep200);
                }
                ImageData imageData = this._getImageData(imageRep200, this.alphaInfo_200);
                return imageData;
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
        return DPIUtil.autoScaleImageData(this.device, this.getImageData(100), zoom, 100);
    }

    NSBitmapImageRep getRepresentation() {
        NSBitmapImageRep rep = null;
        int scaleFactor = DPIUtil.getDeviceZoom();
        switch (scaleFactor) {
            case 100: {
                rep = this.getRepresentation_100();
                break;
            }
            case 200: {
                rep = this.getRepresentation_200();
            }
        }
        if (rep == null) {
            NSSize targetSize = new NSSize();
            NSSize imgSize = this.handle.size();
            targetSize.width = (int)imgSize.width * scaleFactor / 100;
            targetSize.height = (int)imgSize.height * scaleFactor / 100;
            rep = this.createImageRep(targetSize);
        }
        NSArray reps = this.handle.representations();
        long count = reps.count();
        int i = 0;
        while ((long)i < count) {
            this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0L)));
            ++i;
        }
        this.handle.addRepresentation(rep);
        return rep;
    }

    NSBitmapImageRep createImageRep(NSSize targetSize) {
        return ImageUtil.createImageRep(this, targetSize);
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(ImageData image) {
        if (image == null) {
            SWT.error(4);
        }
        if (this.handle != null) {
            this.handle.release();
        }
        this.handle = (NSImage)new NSImage().alloc();
        NSSize size = new NSSize();
        size.width = this.width;
        size.height = this.height;
        this.handle = this.handle.initWithSize(size);
        this.width = image.width;
        this.height = image.height;
        if (this.alphaInfo_100 == null) {
            this.alphaInfo_100 = new AlphaInfo();
        }
        NSBitmapImageRep rep = this.createRepresentation(image, this.alphaInfo_100);
        this.handle.addRepresentation(rep);
        rep.release();
        this.handle.setCacheMode(3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAlpha_200(NSBitmapImageRep nativeRep) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int width = (int)nativeRep.pixelsWide();
            int height = (int)nativeRep.pixelsHigh();
            boolean hasAlpha = nativeRep.hasAlpha();
            int bpr = width * 4;
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, hasAlpha ? 4L : 3L, hasAlpha, false, OS.NSDeviceRGBColorSpace, 3L, bpr, 32L);
            if (this.alphaInfo_200 == null) {
                this.alphaInfo_200 = new AlphaInfo();
            }
            this.alphaInfo_200.init(nativeRep, rep);
            rep.release();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAlpha_100(NSBitmapImageRep nativeRep) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int width = (int)nativeRep.pixelsWide();
            int height = (int)nativeRep.pixelsHigh();
            boolean hasAlpha = nativeRep.hasAlpha();
            int bpr = width * 4;
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, hasAlpha ? 4L : 3L, hasAlpha, false, OS.NSDeviceRGBColorSpace, 3L, bpr, 32L);
            if (this.alphaInfo_100 == null) {
                this.alphaInfo_100 = new AlphaInfo();
            }
            this.alphaInfo_100.init(nativeRep, rep);
            rep.release();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long internal_new_GC(GCData data) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSGraphicsContext flippedContext;
            int scaleFactor = DPIUtil.getDeviceZoom() / 100;
            NSBitmapImageRep imageRep = this.getRepresentation();
            NSGraphicsContext context = NSGraphicsContext.graphicsContextWithBitmapImageRep(imageRep);
            context = flippedContext = NSGraphicsContext.graphicsContextWithGraphicsPort(context.graphicsPort(), true);
            context.retain();
            if (data != null) {
                data.flippedContext = flippedContext;
            }
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(context);
            NSAffineTransform transform = NSAffineTransform.transform();
            NSSize size = this.handle.size();
            transform.translateXBy(0.0, size.height * (double)scaleFactor);
            transform.scaleXBy(scaleFactor, -scaleFactor);
            transform.set();
            NSGraphicsContext.static_restoreGraphicsState();
            if (data != null) {
                int mask = 0x6000000;
                if ((data.style & mask) == 0) {
                    data.style |= 0x2000000;
                }
                data.device = this.device;
                data.background = this.device.COLOR_WHITE.handle;
                data.foreground = this.device.COLOR_BLACK.handle;
                data.font = this.device.systemFont;
                data.image = this;
            }
            long l = context.id;
            return l;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        long context = hDC;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (context != 0L) {
                NSBitmapImageRep imageRep = this.getRepresentation();
                imageRep.bitmapData();
                NSGraphicsContext contextObj = new NSGraphicsContext(context);
                contextObj.release();
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    static class AlphaInfo {
        byte[] alphaData;
        int alpha = -1;
        int transparentPixel = -1;

        AlphaInfo() {
        }

        void init(NSImageRep nativeRep, NSBitmapImageRep rep) {
            int width = (int)nativeRep.pixelsWide();
            int height = (int)nativeRep.pixelsHigh();
            this.transparentPixel = -1;
            this.alpha = -1;
            boolean hasAlpha = rep.hasAlpha();
            int bpr = width * 4;
            NSRect rect = new NSRect();
            rect.width = width;
            rect.height = height;
            long colorspace = OS.CGColorSpaceCreateDeviceRGB();
            long ctx = OS.CGBitmapContextCreate(rep.bitmapData(), width, height, 8L, bpr, colorspace, 6);
            OS.CGColorSpaceRelease(colorspace);
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(ctx, false));
            nativeRep.drawInRect(rect);
            NSGraphicsContext.static_restoreGraphicsState();
            OS.CGContextRelease(ctx);
            if (hasAlpha) {
                long bitmapBytesPerRow = width;
                long bitmapByteCount = bitmapBytesPerRow * (long)height;
                long alphaBitmapData = C.malloc(bitmapByteCount);
                long alphaBitmapCtx = OS.CGBitmapContextCreate(alphaBitmapData, width, height, 8L, bitmapBytesPerRow, 0L, 7);
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(alphaBitmapCtx, false));
                nativeRep.drawInRect(rect);
                NSGraphicsContext.static_restoreGraphicsState();
                byte[] alphaData = new byte[(int)bitmapByteCount];
                C.memmove(alphaData, alphaBitmapData, bitmapByteCount);
                C.free(alphaBitmapData);
                OS.CGContextRelease(alphaBitmapCtx);
                byte[] srcData = new byte[height * bpr];
                C.memmove(srcData, rep.bitmapData(), (long)srcData.length);
                int a = 0;
                int p = 0;
                while (a < alphaData.length) {
                    srcData[p] = alphaData[a];
                    float alpha = alphaData[a] & 0xFF;
                    if (alpha != 0.0f) {
                        srcData[p + 1] = (byte)((float)(srcData[p + 1] & 0xFF) / alpha * 255.0f);
                        srcData[p + 2] = (byte)((float)(srcData[p + 2] & 0xFF) / alpha * 255.0f);
                        srcData[p + 3] = (byte)((float)(srcData[p + 3] & 0xFF) / alpha * 255.0f);
                    }
                    ++a;
                    p += 4;
                }
                C.memmove(rep.bitmapData(), srcData, (long)srcData.length);
                int transparentOffset = -1;
                int i = 0;
                for (i = 0; i < alphaData.length; ++i) {
                    byte alpha = alphaData[i];
                    if (transparentOffset == -1 && alpha == 0) {
                        transparentOffset = i;
                    }
                    if (alpha != 0 && alpha != -1) break;
                }
                this.alpha = -1;
                if (i == alphaData.length && transparentOffset != -1) {
                    NSColor color = rep.colorAtX(transparentOffset % width, transparentOffset / width);
                    int red = (int)(color.redComponent() * 255.0);
                    int green = (int)(color.greenComponent() * 255.0);
                    int blue = (int)(color.blueComponent() * 255.0);
                    this.transparentPixel = red << 16 | green << 8 | blue;
                    for (int j = 0; j < srcData.length; j += 4) {
                        int pixel;
                        if (srcData[j] == 0 || (pixel = (srcData[j + 1] & 0xFF) << 16 | (srcData[j + 2] & 0xFF) << 8 | srcData[j + 3] & 0xFF) != this.transparentPixel) continue;
                        this.transparentPixel = -1;
                        break;
                    }
                }
                if (this.transparentPixel == -1) {
                    this.alphaData = alphaData;
                }
            }
        }
    }
}

