/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.OS;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text;
    StyleItem[] styles;
    int stylesCount;
    int[] segments;
    char[] segmentsChars;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static final byte[] SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};

    @Override
    void destroy() {
        this.freeRuns();
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
        this.font = null;
        this.text = null;
        this.styles = null;
        this.segments = null;
        this.segmentsChars = null;
    }

    void freeRuns() {
        this.lineBounds = null;
        this.lineOffsets = null;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            StyleItem run = this.styles[i];
            if (run.cell == null) continue;
            OS.object_setInstanceVariable(run.cell.id, SWT_OBJECT, 0L);
            run.cell.release();
            run.cell = null;
            OS.DeleteGlobalRef(run.jniRef);
            run.jniRef = 0L;
        }
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    static class StyleItem {
        TextStyle style;
        int start;
        long jniRef;
        NSCell cell;

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

