/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class Library {
    static int MAJOR_VERSION = 4;
    static int MINOR_VERSION = 934;
    static int REVISION = 5;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    public static final String USER_HOME;
    static final String SEPARATOR;
    static final String DELIMITER;
    static final String JAVA_LIB_PATH = "java.library.path";
    static final String SWT_LIB_PATH = "swt.library.path";
    static final boolean IS_64;
    static final String SUFFIX_64 = "-64";
    static final String SWT_LIB_DIR;

    static String arch() {
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("i386") || osArch.equals("i686")) {
            return "x86";
        }
        if (osArch.equals("amd64")) {
            return "x86_64";
        }
        return osArch;
    }

    static String os() {
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux")) {
            return "linux";
        }
        if (osName.equals("Mac OS X")) {
            return "macosx";
        }
        if (osName.startsWith("Win")) {
            return "win32";
        }
        return osName;
    }

    static void chmod(String permision, String path) {
        if (Library.os().equals("win32")) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", permision, path}).waitFor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static long longConst() {
        return 0x1FFFFFFFFL;
    }

    static int parseVersion(String version) {
        int index;
        if (version == null) {
            return 0;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        int length = version.length();
        int start = 0;
        for (index = 0; index < length && Character.isDigit(version.charAt(index)); ++index) {
        }
        try {
            if (start < length) {
                major = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                minor = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                micro = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Library.JAVA_VERSION(major, minor, micro);
    }

    public static int JAVA_VERSION(int major, int minor, int micro) {
        return (major << 16) + (minor << 8) + micro;
    }

    public static int SWT_VERSION(int major, int minor) {
        return major * 1000 + minor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractResource(String resourceName, File outFile) {
        try (InputStream inputStream = Library.class.getResourceAsStream(resourceName);){
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            Files.copy(inputStream, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean extract(String extractToFilePath, String mappedName) {
        File tempFile;
        File file = new File(extractToFilePath);
        if (file.exists()) {
            return true;
        }
        try {
            tempFile = File.createTempFile(file.getName(), ".tmp", file.getParentFile());
        }
        catch (Throwable e) {
            return false;
        }
        String resourceName = "/" + mappedName;
        if (!Library.extractResource(resourceName, tempFile)) {
            tempFile.delete();
            return false;
        }
        Library.chmod("755", tempFile.getPath());
        try {
            Files.move(tempFile.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (Throwable e) {
            tempFile.delete();
        }
        return true;
    }

    static boolean load(String libName, StringBuilder message) {
        try {
            if (libName.contains(SEPARATOR)) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (message.length() == 0) {
                message.append(DELIMITER);
            }
            message.append('\t');
            message.append(e.getMessage());
            message.append(DELIMITER);
            return false;
        }
    }

    public static void loadLibrary(String name) {
        Library.loadLibrary(name, true);
    }

    public static void loadLibrary(String name, boolean mapName) {
        String mappedName2;
        String mappedName1;
        String libName2;
        String libName1;
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null) {
            if ("32".equals(prop) && IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
            }
            if ("64".equals(prop) && !IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 32-bit SWT libraries on 64-bit JVM");
            }
        }
        if (mapName) {
            String version = Library.getVersionString();
            libName1 = name + "-" + "cocoa" + "-" + version;
            libName2 = name + "-" + "cocoa";
            mappedName1 = Library.mapLibraryName(libName1);
            mappedName2 = Library.mapLibraryName(libName2);
        } else {
            mappedName1 = mappedName2 = name;
            libName2 = mappedName2;
            libName1 = mappedName2;
        }
        StringBuilder message = new StringBuilder();
        String path = System.getProperty(SWT_LIB_PATH);
        if (path != null) {
            if (Library.load((path = new File(path).getAbsolutePath()) + SEPARATOR + mappedName1, message)) {
                return;
            }
            if (mapName && Library.load(path + SEPARATOR + mappedName2, message)) {
                return;
            }
        }
        if (Library.load(libName1, message)) {
            return;
        }
        if (mapName && Library.load(libName2, message)) {
            return;
        }
        String fileName1 = mappedName1;
        String fileName2 = mappedName2;
        if (path == null) {
            path = USER_HOME;
            File dir = new File(path, SWT_LIB_DIR);
            if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
                path = dir.getAbsolutePath();
            } else if (IS_64) {
                fileName1 = Library.mapLibraryName(libName1 + SUFFIX_64);
                fileName2 = Library.mapLibraryName(libName2 + SUFFIX_64);
            }
            if (Library.load(path + SEPARATOR + fileName1, message)) {
                return;
            }
            if (mapName && Library.load(path + SEPARATOR + fileName2, message)) {
                return;
            }
        }
        if (path != null) {
            if (Library.extract(path + SEPARATOR + fileName1, mappedName1) && Library.load(path + SEPARATOR + fileName1, message)) {
                return;
            }
            if (mapName && Library.extract(path + SEPARATOR + fileName2, mappedName2) && Library.load(path + SEPARATOR + fileName2, message)) {
                return;
            }
        }
        throw new UnsatisfiedLinkError("Could not load SWT library. Reasons: " + message.toString());
    }

    static String mapLibraryName(String libName) {
        String ext;
        if ((libName = System.mapLibraryName(libName)).endsWith(ext = ".dylib")) {
            libName = libName.substring(0, libName.length() - ext.length()) + ".jnilib";
        }
        return libName;
    }

    public static String getVersionString() {
        String version = System.getProperty("swt.version");
        if (version == null) {
            version = "" + MAJOR_VERSION;
            if (MINOR_VERSION < 10) {
                version = version + "00";
            } else if (MINOR_VERSION < 100) {
                version = version + "0";
            }
            version = version + MINOR_VERSION;
            if (REVISION > 0) {
                version = version + "r" + REVISION;
            }
        }
        return version;
    }

    static {
        IS_64 = Library.longConst() == Library.longConst();
        DELIMITER = System.lineSeparator();
        SEPARATOR = File.separator;
        USER_HOME = System.getProperty("user.home");
        SWT_LIB_DIR = ".swt" + SEPARATOR + "lib" + SEPARATOR + Library.os() + SEPARATOR + Library.arch();
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }
}

