/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.cocoa;

import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public class NSTableView
extends NSControl {
    public NSTableView() {
    }

    public NSTableView(long id2) {
        super(id2);
    }

    public void addTableColumn(NSTableColumn tableColumn) {
        OS.objc_msgSend(this.id, OS.sel_addTableColumn_, tableColumn != null ? tableColumn.id : 0L);
    }

    public long clickedColumn() {
        return OS.objc_msgSend(this.id, OS.sel_clickedColumn);
    }

    public long clickedRow() {
        return OS.objc_msgSend(this.id, OS.sel_clickedRow);
    }

    public long columnAtPoint(NSPoint point) {
        return OS.objc_msgSend(this.id, OS.sel_columnAtPoint_, point);
    }

    public void deselectAll(id sender) {
        OS.objc_msgSend(this.id, OS.sel_deselectAll_, sender != null ? sender.id : 0L);
    }

    public void deselectRow(long row) {
        OS.objc_msgSend(this.id, OS.sel_deselectRow_, row);
    }

    public NSRect frameOfCellAtColumn(long column, long row) {
        NSRect result = new NSRect();
        OS.objc_msgSend_stret(result, this.id, OS.sel_frameOfCellAtColumn_row_, column, row);
        return result;
    }

    public NSTableHeaderView headerView() {
        long result = OS.objc_msgSend(this.id, OS.sel_headerView);
        return result != 0L ? new NSTableHeaderView(result) : null;
    }

    public NSSize intercellSpacing() {
        NSSize result = new NSSize();
        OS.objc_msgSend_stret(result, this.id, OS.sel_intercellSpacing);
        return result;
    }

    public boolean isRowSelected(long row) {
        return OS.objc_msgSend_bool(this.id, OS.sel_isRowSelected_, row);
    }

    public void moveColumn(long oldIndex, long newIndex) {
        OS.objc_msgSend(this.id, OS.sel_moveColumn_toColumn_, oldIndex, newIndex);
    }

    public void noteNumberOfRowsChanged() {
        OS.objc_msgSend(this.id, OS.sel_noteNumberOfRowsChanged);
    }

    public long numberOfColumns() {
        return OS.objc_msgSend(this.id, OS.sel_numberOfColumns);
    }

    public long numberOfSelectedRows() {
        return OS.objc_msgSend(this.id, OS.sel_numberOfSelectedRows);
    }

    public NSCell preparedCellAtColumn(long column, long row) {
        long result = OS.objc_msgSend(this.id, OS.sel_preparedCellAtColumn_row_, column, row);
        return result != 0L ? new NSCell(result) : null;
    }

    public NSRect rectOfColumn(long column) {
        NSRect result = new NSRect();
        OS.objc_msgSend_stret(result, this.id, OS.sel_rectOfColumn_, column);
        return result;
    }

    public NSRect rectOfRow(long row) {
        NSRect result = new NSRect();
        OS.objc_msgSend_stret(result, this.id, OS.sel_rectOfRow_, row);
        return result;
    }

    public void removeTableColumn(NSTableColumn tableColumn) {
        OS.objc_msgSend(this.id, OS.sel_removeTableColumn_, tableColumn != null ? tableColumn.id : 0L);
    }

    public long rowAtPoint(NSPoint point) {
        return OS.objc_msgSend(this.id, OS.sel_rowAtPoint_, point);
    }

    public double rowHeight() {
        return OS.objc_msgSend_fpret(this.id, OS.sel_rowHeight);
    }

    public void scrollColumnToVisible(long column) {
        OS.objc_msgSend(this.id, OS.sel_scrollColumnToVisible_, column);
    }

    public void scrollRowToVisible(long row) {
        OS.objc_msgSend(this.id, OS.sel_scrollRowToVisible_, row);
    }

    public void selectAll(id sender) {
        OS.objc_msgSend(this.id, OS.sel_selectAll_, sender != null ? sender.id : 0L);
    }

    public void selectRowIndexes(NSIndexSet indexes, boolean extend) {
        OS.objc_msgSend(this.id, OS.sel_selectRowIndexes_byExtendingSelection_, indexes != null ? indexes.id : 0L, extend);
    }

    public long selectedRow() {
        return OS.objc_msgSend(this.id, OS.sel_selectedRow);
    }

    public NSIndexSet selectedRowIndexes() {
        long result = OS.objc_msgSend(this.id, OS.sel_selectedRowIndexes);
        return result != 0L ? new NSIndexSet(result) : null;
    }

    public void setAllowsMultipleSelection(boolean allowsMultipleSelection) {
        OS.objc_msgSend(this.id, OS.sel_setAllowsMultipleSelection_, allowsMultipleSelection);
    }

    public void setBackgroundColor(NSColor backgroundColor) {
        OS.objc_msgSend(this.id, OS.sel_setBackgroundColor_, backgroundColor != null ? backgroundColor.id : 0L);
    }

    public void setColumnAutoresizingStyle(long columnAutoresizingStyle) {
        OS.objc_msgSend(this.id, OS.sel_setColumnAutoresizingStyle_, columnAutoresizingStyle);
    }

    public void setDataSource(id aSource) {
        OS.objc_msgSend(this.id, OS.sel_setDataSource_, aSource != null ? aSource.id : 0L);
    }

    public void setDelegate(id delegate) {
        OS.objc_msgSend(this.id, OS.sel_setDelegate_, delegate != null ? delegate.id : 0L);
    }

    public void setDoubleAction(long doubleAction) {
        OS.objc_msgSend(this.id, OS.sel_setDoubleAction_, doubleAction);
    }

    public void setGridStyleMask(long gridStyleMask) {
        OS.objc_msgSend(this.id, OS.sel_setGridStyleMask_, gridStyleMask);
    }

    public void setHeaderView(NSTableHeaderView headerView) {
        OS.objc_msgSend(this.id, OS.sel_setHeaderView_, headerView != null ? headerView.id : 0L);
    }

    public void setHighlightedTableColumn(NSTableColumn highlightedTableColumn) {
        OS.objc_msgSend(this.id, OS.sel_setHighlightedTableColumn_, highlightedTableColumn != null ? highlightedTableColumn.id : 0L);
    }

    public void setIndicatorImage(NSImage anImage, NSTableColumn tableColumn) {
        OS.objc_msgSend(this.id, OS.sel_setIndicatorImage_inTableColumn_, anImage != null ? anImage.id : 0L, tableColumn != null ? tableColumn.id : 0L);
    }

    public void setIntercellSpacing(NSSize intercellSpacing) {
        OS.objc_msgSend(this.id, OS.sel_setIntercellSpacing_, intercellSpacing);
    }

    public void setRowHeight(double rowHeight) {
        OS.objc_msgSend(this.id, OS.sel_setRowHeight_, rowHeight);
    }

    public void setUsesAlternatingRowBackgroundColors(boolean usesAlternatingRowBackgroundColors) {
        OS.objc_msgSend(this.id, OS.sel_setUsesAlternatingRowBackgroundColors_, usesAlternatingRowBackgroundColors);
    }

    public NSArray tableColumns() {
        long result = OS.objc_msgSend(this.id, OS.sel_tableColumns);
        return result != 0L ? new NSArray(result) : null;
    }

    public void tile() {
        OS.objc_msgSend(this.id, OS.sel_tile);
    }

    public boolean usesAlternatingRowBackgroundColors() {
        return OS.objc_msgSend_bool(this.id, OS.sel_usesAlternatingRowBackgroundColors);
    }
}

