/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LEDataOutputStream;

public abstract class FileFormat {
    static final String FORMAT_PACKAGE = "org.eclipse.swt.internal.image";
    static final String FORMAT_SUFFIX = "FileFormat";
    static final String[] FORMATS = new String[]{"WinBMP", "WinBMP", "GIF", "WinICO", "JPEG", "PNG", "TIFF", "OS2BMP"};
    LEDataInputStream inputStream;
    LEDataOutputStream outputStream;
    ImageLoader loader;
    int compression;

    static FileFormat getFileFormat(LEDataInputStream stream, String format) throws Exception {
        Class<?> clazz = Class.forName("org.eclipse.swt.internal.image." + format + FORMAT_SUFFIX);
        FileFormat fileFormat = (FileFormat)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (fileFormat.isFileFormat(stream)) {
            return fileFormat;
        }
        return null;
    }

    abstract boolean isFileFormat(LEDataInputStream var1);

    abstract ImageData[] loadFromByteStream();

    public ImageData[] loadFromStream(LEDataInputStream stream) {
        try {
            this.inputStream = stream;
            return this.loadFromByteStream();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                SWT.error(39, e);
            } else {
                SWT.error(40, e);
            }
            return null;
        }
    }

    public static ImageData[] load(InputStream is, ImageLoader loader) {
        FileFormat fileFormat = null;
        LEDataInputStream stream = new LEDataInputStream(is);
        for (int i = 1; i < FORMATS.length; ++i) {
            if (FORMATS[i] == null) continue;
            try {
                fileFormat = FileFormat.getFileFormat(stream, FORMATS[i]);
                if (fileFormat == null) continue;
                break;
            }
            catch (ClassNotFoundException e) {
                FileFormat.FORMATS[i] = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileFormat == null) {
            SWT.error(42);
        }
        fileFormat.loader = loader;
        return fileFormat.loadFromStream(stream);
    }
}

