/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.cocoa.NSAlert;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";
    int returnCode;

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(parent, MessageBox.checkStyle(style)));
        if (Display.getSheetEnabled() && parent != null && (style & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    static int checkStyle(int style) {
        int mask = 4064;
        int bits = style & mask;
        if (bits == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }

    public int open() {
        Display display;
        NSString title;
        NSImage icon;
        NSAlert alert = (NSAlert)new NSAlert().alloc().init();
        int alertType = 1;
        if ((this.style & 1) != 0) {
            alertType = 2;
        }
        if ((this.style & 2) != 0 || (this.style & 0x10) != 0 || (this.style & 4) != 0) {
            alertType = 1;
            icon = Display.getSystemImageForID(1852798053);
            alert.setIcon(icon);
            icon.release();
        }
        if ((this.style & 8) != 0) {
            alertType = 0;
            icon = Display.getSystemImageForID(1667331444);
            alert.setIcon(icon);
            icon.release();
        }
        alert.setAlertStyle(alertType);
        int mask = 4064;
        int bits = this.style & mask;
        switch (bits) {
            case 32: {
                title = NSString.stringWith(SWT.getMessage("SWT_OK"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 256: {
                title = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 288: {
                title = NSString.stringWith(SWT.getMessage("SWT_OK"));
                alert.addButtonWithTitle(title);
                title = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 64: {
                title = NSString.stringWith(SWT.getMessage("SWT_Yes"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 128: {
                title = NSString.stringWith(SWT.getMessage("SWT_No"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 192: {
                title = NSString.stringWith(SWT.getMessage("SWT_Yes"));
                alert.addButtonWithTitle(title);
                title = NSString.stringWith(SWT.getMessage("SWT_No"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 448: {
                title = NSString.stringWith(SWT.getMessage("SWT_Yes"));
                alert.addButtonWithTitle(title);
                title = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                alert.addButtonWithTitle(title);
                title = NSString.stringWith(SWT.getMessage("SWT_No"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 1280: {
                title = NSString.stringWith(SWT.getMessage("SWT_Retry"));
                alert.addButtonWithTitle(title);
                title = NSString.stringWith(SWT.getMessage("SWT_Cancel"));
                alert.addButtonWithTitle(title);
                break;
            }
            case 3584: {
                title = NSString.stringWith(SWT.getMessage("SWT_Abort"));
                alert.addButtonWithTitle(title);
                title = NSString.stringWith(SWT.getMessage("SWT_Ignore"));
                alert.addButtonWithTitle(title);
                title = NSString.stringWith(SWT.getMessage("SWT_Retry"));
                alert.addButtonWithTitle(title);
            }
        }
        title = NSString.stringWith(this.title != null ? this.title : "");
        NSPanel panel = alert.window();
        panel.setTitle(title);
        NSString message = NSString.stringWith(this.message != null ? this.message : "");
        alert.setMessageText(message);
        int response = 0;
        long jniRef = 0L;
        SWTPanelDelegate delegate = null;
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if ((this.style & 0x10000000) != 0) {
            delegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            jniRef = OS.NewGlobalRef(this);
            if (jniRef == 0L) {
                this.error(2);
            }
            OS.object_setInstanceVariable(delegate.id, Display.SWT_OBJECT, jniRef);
            alert.beginSheetModalForWindow(this.parent.view.window(), delegate, OS.sel_panelDidEnd_returnCode_contextInfo_, 0L);
            display.setModalDialog(this, panel);
            if ((this.style & 0x10000) != 0) {
                response = (int)alert.runModal();
            } else {
                this.returnCode = 0;
                NSPanel window = alert.window();
                while (window.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                response = this.returnCode;
            }
        } else {
            display.setModalDialog(this, panel);
            response = (int)alert.runModal();
        }
        display.setModalDialog(null);
        if (delegate != null) {
            delegate.release();
        }
        if (jniRef != 0L) {
            OS.DeleteGlobalRef(jniRef);
        }
        alert.release();
        switch (bits) {
            case 32: {
                switch (response) {
                    case 1000: {
                        return 32;
                    }
                }
                break;
            }
            case 256: {
                switch (response) {
                    case 1000: {
                        return 256;
                    }
                }
                break;
            }
            case 288: {
                switch (response) {
                    case 1000: {
                        return 32;
                    }
                    case 1001: {
                        return 256;
                    }
                }
                break;
            }
            case 64: {
                switch (response) {
                    case 1000: {
                        return 64;
                    }
                }
                break;
            }
            case 128: {
                switch (response) {
                    case 1000: {
                        return 128;
                    }
                }
                break;
            }
            case 192: {
                switch (response) {
                    case 1000: {
                        return 64;
                    }
                    case 1001: {
                        return 128;
                    }
                }
                break;
            }
            case 448: {
                switch (response) {
                    case 1000: {
                        return 64;
                    }
                    case 1001: {
                        return 256;
                    }
                    case 1002: {
                        return 128;
                    }
                }
                break;
            }
            case 1280: {
                switch (response) {
                    case 1000: {
                        return 1024;
                    }
                    case 1001: {
                        return 256;
                    }
                }
                break;
            }
            case 3584: {
                switch (response) {
                    case 1000: {
                        return 512;
                    }
                    case 1001: {
                        return 2048;
                    }
                    case 1002: {
                        return 1024;
                    }
                }
            }
        }
        return 256;
    }

    void panelDidEnd_returnCode_contextInfo(long id2, long sel, long alert, long returnCode, long contextInfo) {
        this.returnCode = (int)returnCode;
        NSApplication application = NSApplication.sharedApplication();
        application.endSheet(new NSAlert(alert).window(), returnCode);
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

