/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableColumn
extends Item {
    Table parent;
    NSTableColumn nsColumn;
    String toolTipText;
    String displayText;
    boolean movable;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.columnCount);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsColumn.headerCell());
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    void drawInteriorWithFrame_inView(long id2, long sel, NSRect cellRect, long view) {
        NSRect destRect;
        NSColor color;
        double borderWidth;
        int columnIndex = this.parent.indexOf(this.nsColumn);
        NSRect headerRect = this.parent.headerView.headerRectOfColumn(columnIndex);
        double d = borderWidth = this.parent.hasBorder() ? 0.5 : 0.0;
        if (headerRect.x != cellRect.x || headerRect.width != cellRect.width) {
            if (this.parent.headerBackground != null) {
                NSGraphicsContext context = NSGraphicsContext.currentContext();
                context.saveGraphicsState();
                double[] colorRGB = this.parent.headerBackground;
                NSColor color2 = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 1.0);
                color2.setFill();
                NSRect rect = new NSRect();
                rect.x = cellRect.x;
                rect.y = headerRect.y + borderWidth;
                rect.width = cellRect.width;
                rect.height = headerRect.height - borderWidth - 0.5;
                NSBezierPath.fillRect(rect);
                context.restoreGraphicsState();
            }
            return;
        }
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        context.saveGraphicsState();
        int contentWidth = 0;
        NSSize stringSize = null;
        NSSize imageSize = null;
        NSAttributedString attrString = null;
        NSTableHeaderCell headerCell = this.nsColumn.headerCell();
        if (this.displayText != null) {
            Font font = Font.cocoa_new(this.display, headerCell.font());
            attrString = this.parent.createString(this.displayText, font, this.parent.getHeaderForegroundColor().handle, 16384, false, (this.parent.state & 8) == 0, false);
            stringSize = attrString.size();
            contentWidth = (int)((double)contentWidth + Math.ceil(stringSize.width));
            if (this.image != null) {
                contentWidth += 2;
            }
        }
        if (this.parent.headerBackground != null) {
            context.saveGraphicsState();
            double[] colorRGB = this.parent.headerBackground;
            NSColor color1 = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 1.0);
            color1.setFill();
            NSRect rect = new NSRect();
            rect.x = headerRect.x;
            rect.y = headerRect.y + borderWidth;
            rect.width = headerRect.width;
            rect.height = headerRect.height - borderWidth - 0.5;
            NSBezierPath.fillRect(rect);
            if (this.parent.headerForeground != null) {
                colorRGB = this.parent.headerForeground;
                color = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 0.6f);
                color.setStroke();
            }
            NSBezierPath path = NSBezierPath.bezierPath();
            NSPoint pt = new NSPoint();
            pt.x = cellRect.x + cellRect.width - 0.5;
            pt.y = cellRect.y + 2.0;
            path.moveToPoint(pt);
            pt.y += cellRect.y + cellRect.height - 4.0;
            path.lineToPoint(pt);
            path.stroke();
            context.restoreGraphicsState();
        }
        if (this.image != null) {
            imageSize = this.image.handle.size();
            contentWidth = (int)((double)contentWidth + Math.ceil(imageSize.width));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            boolean ascending;
            boolean bl = ascending = this.parent.sortDirection == 128;
            if (this.parent.headerBackground != null || this.parent.headerForeground != null) {
                NSRect sortIndicatorRect = headerCell.sortIndicatorRectForBounds(cellRect);
                context.saveGraphicsState();
                if (this.parent.headerForeground != null) {
                    double[] colorRGB = this.parent.headerForeground;
                    color = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 0.9f);
                    color.setStroke();
                }
                NSBezierPath path = NSBezierPath.bezierPath();
                path.setLineWidth(1.5);
                NSPoint pt = new NSPoint();
                double y1 = sortIndicatorRect.y + sortIndicatorRect.height / 2.0 - 1.5;
                double y2 = sortIndicatorRect.y + sortIndicatorRect.height / 2.0 + 1.5;
                double x1 = sortIndicatorRect.x;
                double x2 = sortIndicatorRect.x + 3.0;
                double x3 = sortIndicatorRect.x + 6.0;
                if (ascending) {
                    pt.x = x1;
                    pt.y = y2;
                    path.moveToPoint(pt);
                    pt.x = x2;
                    pt.y = y1;
                    path.lineToPoint(pt);
                    pt.x = x3;
                    pt.y = y2;
                    path.lineToPoint(pt);
                } else {
                    pt.x = x1;
                    pt.y = y1;
                    path.moveToPoint(pt);
                    pt.x = x2;
                    pt.y = y2;
                    path.lineToPoint(pt);
                    pt.x = x3;
                    pt.y = y1;
                    path.lineToPoint(pt);
                }
                path.stroke();
                context.restoreGraphicsState();
            } else {
                headerCell.drawSortIndicatorWithFrame(cellRect, new NSView(view), ascending, 0L);
            }
            NSRect sortRect = headerCell.sortIndicatorRectForBounds(cellRect);
            cellRect.width = Math.max(0.0, sortRect.x - cellRect.x);
        }
        int drawX = 0;
        drawX = (this.style & 0x1000000) != 0 ? (int)(cellRect.x + Math.max(2.0, (cellRect.width - (double)contentWidth) / 2.0)) : ((this.style & 0x20000) != 0 ? (int)(cellRect.x + Math.max(2.0, cellRect.width - (double)contentWidth - 2.0)) : (int)cellRect.x + 2);
        if (this.image != null) {
            destRect = new NSRect();
            destRect.x = drawX;
            destRect.y = Math.max(cellRect.y, cellRect.y + (cellRect.height - imageSize.height) / 2.0);
            destRect.width = Math.min(imageSize.width, cellRect.width - 4.0);
            destRect.height = Math.min(imageSize.height, cellRect.height);
            boolean isFlipped = new NSView(view).isFlipped();
            if (isFlipped) {
                context.saveGraphicsState();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.scaleXBy(1.0, -1.0);
                transform.translateXBy(0.0, -(destRect.height + 2.0 * destRect.y));
                transform.concat();
            }
            NSRect sourceRect = new NSRect();
            sourceRect.width = destRect.width;
            sourceRect.height = destRect.height;
            this.image.handle.drawInRect(destRect, sourceRect, 2L, 1.0);
            if (isFlipped) {
                context.restoreGraphicsState();
            }
            drawX = (int)((double)drawX + destRect.width);
        }
        if (this.displayText != null && this.displayText.length() > 0) {
            if (this.image != null) {
                drawX += 2;
            }
            destRect = new NSRect();
            destRect.x = drawX;
            destRect.y = cellRect.y;
            destRect.width = Math.min(stringSize.width, cellRect.x + cellRect.width - 2.0 - (double)drawX);
            destRect.height = Math.min(stringSize.height, cellRect.height);
            attrString.drawInRect(destRect);
        }
        if (attrString != null) {
            attrString.release();
        }
        context.restoreGraphicsState();
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getWidth() {
        this.checkWidget();
        int width = (int)this.nsColumn.width();
        if (width > 0) {
            ++width;
        }
        return width;
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsColumn != null) {
            this.nsColumn.headerCell().release();
            this.nsColumn.release();
        }
        this.nsColumn = null;
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        NSTableHeaderView headerView = ((NSTableView)this.parent.view).headerView();
        if (headerView == null) {
            return;
        }
        int index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        this.displayText = new String(buffer, 0, length);
        NSString title = NSString.stringWith(this.displayText);
        this.nsColumn.headerCell().setTitle(title);
        NSTableHeaderView headerView = ((NSTableView)this.parent.view).headerView();
        if (headerView == null) {
            return;
        }
        int index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width < 0) {
            return;
        }
        width = Math.max(0, width - 1);
        this.nsColumn.setWidth(width);
    }

    @Override
    String tooltipText() {
        return this.toolTipText;
    }
}

