/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.rocksaw.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import net.azib.ipscan.core.LibraryLoader;

public class RawSocket {
    private int __socket = -1;
    private int __family = -1;
    private TimeVal __stimeout = new TimeVal();
    private TimeVal __rtimeout = new TimeVal();
    private boolean __useSelectTimeout;

    private static native int __RockSawStartup();

    static native void __RockSawShutdown();

    public RawSocket() {
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith("SunOS")) {
            this.setUseSelectTimeout(true);
        } else {
            this.setUseSelectTimeout(false);
        }
    }

    public boolean isOpen() {
        return this.__socket > 0;
    }

    private static native void __getErrorMessage(StringBuffer var0);

    private static String __getErrorMessage() {
        StringBuffer buf = new StringBuffer();
        RawSocket.__getErrorMessage(buf);
        return buf.toString();
    }

    private static void __throwIOException() throws IOException {
        throw new IOException(RawSocket.__getErrorMessage());
    }

    private static void __throwSocketException() throws SocketException {
        throw new SocketException(RawSocket.__getErrorMessage());
    }

    private static void __throwInterruptedIOException() throws InterruptedIOException {
        throw new InterruptedIOException(RawSocket.__getErrorMessage());
    }

    private static native int __socket(int var0, int var1);

    public static final native int getProtocolByName(String var0);

    public void open(int protocolFamily, int protocol) throws IllegalStateException, IOException {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        this.__socket = RawSocket.__socket(protocolFamily, protocol);
        if (this.__socket < 0) {
            this.__socket = -1;
            RawSocket.__throwIOException();
        }
        this.__family = protocolFamily;
    }

    private static native int __close(int var0);

    public void close() throws IOException {
        int result = RawSocket.__close(this.__socket);
        this.__socket = -1;
        this.__family = -1;
        if (result != 0) {
            RawSocket.__throwIOException();
        }
    }

    private native boolean __isErrorEAGAIN();

    private static native int __setIPHeaderInclude(int var0, boolean var1);

    private static native int __getIPHeaderInclude(int var0);

    public void setIPHeaderInclude(boolean on) throws SocketException {
        int result = RawSocket.__setIPHeaderInclude(this.__socket, on);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
    }

    public boolean getIPHeaderInclude() throws SocketException {
        int result = RawSocket.__getIPHeaderInclude(this.__socket);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
        return result > 0;
    }

    private static native int __setSendBufferSize(int var0, int var1);

    public void setSendBufferSize(int size) throws SocketException {
        int result = RawSocket.__setSendBufferSize(this.__socket, size);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
    }

    private static native int __getSendBufferSize(int var0);

    public int getSendBufferSize() throws SocketException {
        int result = RawSocket.__getSendBufferSize(this.__socket);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
        return result;
    }

    private static native int __setReceiveBufferSize(int var0, int var1);

    public void setReceiveBufferSize(int size) throws SocketException {
        int result = RawSocket.__setReceiveBufferSize(this.__socket, size);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
    }

    private static native int __getReceiveBufferSize(int var0);

    public int getReceiveBufferSize() throws SocketException {
        int result = RawSocket.__getReceiveBufferSize(this.__socket);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
        return result;
    }

    private static native int __select(int var0, boolean var1, int var2, int var3);

    public void setUseSelectTimeout(boolean useSelect) {
        this.__useSelectTimeout = useSelect;
    }

    public boolean getUseSelectTimeout() {
        return this.__useSelectTimeout;
    }

    private static native int __setSendTimeout(int var0, int var1);

    public void setSendTimeout(int timeout) throws SocketException {
        int result;
        this.__stimeout.setInMilliseconds(timeout);
        if (!this.getUseSelectTimeout() && (result = RawSocket.__setSendTimeout(this.__socket, timeout)) < 0) {
            RawSocket.__throwSocketException();
        }
    }

    private static native int __getSendTimeout(int var0);

    public int getSendTimeout() throws SocketException {
        int result;
        if (this.getUseSelectTimeout()) {
            result = this.__stimeout.getInMilliseconds();
        } else {
            result = RawSocket.__getSendTimeout(this.__socket);
            if (result < 0) {
                RawSocket.__throwSocketException();
            }
        }
        return result;
    }

    private static native int __setReceiveTimeout(int var0, int var1);

    public void setReceiveTimeout(int timeout) throws SocketException {
        int result;
        this.__rtimeout.setInMilliseconds(timeout);
        if (!this.getUseSelectTimeout() && (result = RawSocket.__setReceiveTimeout(this.__socket, timeout)) < 0) {
            RawSocket.__throwSocketException();
        }
    }

    private static native int __getReceiveTimeout(int var0);

    public int getReceiveTimeout() throws SocketException {
        int result;
        if (this.getUseSelectTimeout()) {
            result = this.__rtimeout.getInMilliseconds();
        } else {
            result = RawSocket.__getReceiveTimeout(this.__socket);
            if (result < 0) {
                RawSocket.__throwSocketException();
            }
        }
        return result;
    }

    private static native int __recvfrom(int var0, byte[] var1, int var2, int var3, int var4, byte[] var5);

    public int read(InetAddress address, byte[] data, int offset, int length) throws IllegalArgumentException, IOException, InterruptedIOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IllegalArgumentException("Invalid offset or length.");
        }
        int result = 0;
        if (this.getUseSelectTimeout() && !this.__rtimeout.isZero()) {
            result = RawSocket.__select(this.__socket, true, this.__rtimeout.seconds, this.__rtimeout.microseconds);
        }
        if (result == 0) {
            result = RawSocket.__recvfrom(this.__socket, data, offset, length, this.__family, address.getAddress());
        }
        if (result < 0) {
            if (this.__isErrorEAGAIN()) {
                RawSocket.__throwInterruptedIOException();
            } else {
                RawSocket.__throwIOException();
            }
        }
        return result;
    }

    public int read(InetAddress address, byte[] data) throws IOException, InterruptedIOException {
        return this.read(address, data, 0, data.length);
    }

    private static native int __sendto(int var0, byte[] var1, int var2, int var3, int var4, byte[] var5);

    public int write(InetAddress address, byte[] data, int offset, int length) throws IllegalArgumentException, IOException, InterruptedIOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IllegalArgumentException("Invalid offset or length.");
        }
        int result = 0;
        if (this.getUseSelectTimeout() && !this.__stimeout.isZero()) {
            result = RawSocket.__select(this.__socket, false, this.__stimeout.seconds, this.__stimeout.microseconds);
        }
        if (result == 0) {
            result = RawSocket.__sendto(this.__socket, data, offset, length, this.__family, address.getAddress());
        }
        if (result < 0) {
            if (this.__isErrorEAGAIN()) {
                RawSocket.__throwInterruptedIOException();
            } else {
                RawSocket.__throwIOException();
            }
        }
        return result;
    }

    public int write(InetAddress address, byte[] data) throws IOException, InterruptedIOException {
        return this.write(address, data, 0, data.length);
    }

    static {
        LibraryLoader.loadLibrary("rocksaw");
        if (RawSocket.__RockSawStartup() != 0) {
            throw new UnsatisfiedLinkError(RawSocket.__getErrorMessage());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> RawSocket.__RockSawShutdown()));
    }

    private static final class TimeVal {
        int seconds = 0;
        int microseconds = 0;

        TimeVal() {
        }

        void setInMilliseconds(int milliseconds) {
            this.seconds = milliseconds / 1000;
            if (this.seconds > 0) {
                milliseconds -= this.seconds * 1000;
            }
            this.microseconds = milliseconds * 1000;
        }

        int getInMilliseconds() {
            return this.seconds * 1000 + this.microseconds / 1000;
        }

        boolean isZero() {
            return this.seconds == 0 && this.microseconds == 0;
        }
    }
}

